/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.ElexisConfigurationConstants;
import ch.elexis.core.ui.medication.handlers.PrintTakingsListHandler;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.core.ui.medication.views.MedicationView;
import ch.elexis.core.ui.views.RezeptBlatt;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Rezept;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintRecipeHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "ch.elexis.core.ui.medication.PrintRecipe";
    private static Logger log = LoggerFactory.getLogger(PrintRecipeHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<Prescription> prescRecipes;
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        if (patient == null) {
            return null;
        }
        String medicationType = event.getParameter("ch.elexis.core.ui.medication.commandParameter.medication");
        if (medicationType == null || medicationType.isEmpty()) {
            medicationType = "selection";
        }
        if (!(prescRecipes = this.getPrescriptions(patient, medicationType, event)).isEmpty()) {
            prescRecipes = this.sortPrescriptions(prescRecipes, event);
            Rezept rp = new Rezept(patient);
            for (Prescription p : prescRecipes) {
                Prescription prescription = new Prescription(p);
                prescription.setEndDate(null);
                rp.addPrescription(prescription);
            }
            try {
                RezeptBlatt rpb = (RezeptBlatt)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ElexisConfigurationConstants.rezeptausgabe);
                rpb.createRezept(rp);
            }
            catch (PartInitException e) {
                log.error("Error outputting recipe", (Throwable)e);
            }
        }
        return null;
    }

    private List<Prescription> sortPrescriptions(List<Prescription> prescRecipes, ExecutionEvent event) {
        PrintTakingsListHandler.SorterAdapter sorter = new PrintTakingsListHandler.SorterAdapter(event);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof MedicationView) {
            return sorter.getSorted(prescRecipes);
        }
        return prescRecipes;
    }

    private List<Prescription> getPrescriptions(Patient patient, String medicationType, ExecutionEvent event) {
        if ("selection".equals(medicationType)) {
            ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
            if (selection != null && !selection.isEmpty()) {
                ArrayList<Prescription> ret = new ArrayList<Prescription>();
                IStructuredSelection strucSelection = (IStructuredSelection)selection;
                if (strucSelection.getFirstElement() instanceof MedicationTableViewerItem) {
                    List mtvItems = strucSelection.toList();
                    for (MedicationTableViewerItem mtvItem : mtvItems) {
                        Prescription p = mtvItem.getPrescription();
                        if (p == null) continue;
                        ret.add(p);
                    }
                } else if (strucSelection.getFirstElement() instanceof Prescription) {
                    ret.addAll(strucSelection.toList());
                }
                return ret;
            }
        } else {
            if ("all".equals(medicationType)) {
                return patient.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION});
            }
            if ("fix".equals(medicationType)) {
                return patient.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION});
            }
            if ("reserve".equals(medicationType)) {
                return patient.getMedication(new EntryType[]{EntryType.RESERVE_MEDICATION});
            }
        }
        return Collections.emptyList();
    }
}

