/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Fall;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveFallAHVNrToContact
extends ExternalMaintenance {
    public static final String AHV_NUMMER = "AHV-Nummer";

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder output = new StringBuilder();
        Query qbe = new Query(Fall.class);
        List qre = qbe.execute();
        pm.beginTask("Verschiebe Fall.AHV-Nummer Zuordnung zu Kontakt", qre.size());
        for (Fall fall : qre) {
            Map extinfo;
            String ahvNummer = fall.getRequiredString(AHV_NUMMER);
            Patient pat = fall.getPatient();
            if (pat == null) {
                output.append("Patient f\u00fcr Fall " + fall.getLabel() + " nicht gefunden!");
                continue;
            }
            String patAhvNummer = pat.getXid("www.ahv.ch/xid");
            if (patAhvNummer.length() < 1 && ahvNummer.length() > 1) {
                output.append("Setze AHV Nummer f\u00fcr " + pat.getLabel() + " auf " + ahvNummer + "\n");
                pat.addXid("www.ahv.ch/xid", ahvNummer, true);
            }
            if ((extinfo = fall.getMap("ExtInfo")).containsKey(AHV_NUMMER)) {
                extinfo.remove(AHV_NUMMER);
                fall.setMap("ExtInfo", extinfo);
                output.append("Entferne AHV-Nummer Eintrag aus Fall " + fall.getLabel() + "\n");
            }
            pm.worked(1);
        }
        pm.done();
        return output.toString();
    }

    @Override
    public String getMaintenanceDescription() {
        return "Fall.AHV-Nummer zu Kontakt.AHV-Nummer verschieben [1439]";
    }
}

