/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.crypt;

import ch.rgw.crypt.Cryptologist;
import ch.rgw.crypt.CryptologistException;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class GnuPG
implements Cryptologist {
    private static final String kGnuPGArgs = " --batch --armor --output -";
    private String homedir;
    private String executable;
    private int gpg_exitCode = -1;
    private String gpg_result;
    private String gpg_err;
    private boolean gpgOK;
    private char[] passphrase;
    private final String identity;

    public void setPassphrase(char[] pwd) {
        this.passphrase = pwd;
    }

    public void setExecutable(String exe) {
        this.executable = exe;
    }

    public void setHomedir(String dir) {
        this.homedir = dir;
    }

    private String createGPGCommand() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.executable).append(" ");
        if (!StringTool.isNothing(this.homedir)) {
            sb.append("--homedir ").append(this.homedir);
        }
        sb.append(kGnuPGArgs);
        return sb.toString();
    }

    public boolean sign(String inStr, String secID, String passPhrase) {
        boolean success = false;
        File tmpFile = this.createTempFile(inStr);
        if (tmpFile != null) {
            success = this.runGnuPG("-u " + secID + " --passphrase-fd 0 -b " + tmpFile.getAbsolutePath(), passPhrase);
            tmpFile.delete();
            if (success && this.gpg_exitCode != 0) {
                success = false;
            }
        }
        return success;
    }

    public boolean clearSign(String inStr, String secID, String passPhrase) {
        boolean success = false;
        File tmpFile = this.createTempFile(inStr);
        if (tmpFile != null) {
            success = this.runGnuPG("-u " + secID + " --passphrase-fd 0 --clearsign " + tmpFile.getAbsolutePath(), passPhrase);
            tmpFile.delete();
            if (success && this.gpg_exitCode != 0) {
                success = false;
            }
        }
        return success;
    }

    public boolean signAndEncrypt(String inStr, String secID, String keyID, String passPhrase) {
        boolean success = false;
        File tmpFile = this.createTempFile(inStr);
        if (tmpFile != null) {
            success = this.runGnuPG("-u " + secID + " -r " + keyID + " --passphrase-fd 0 -se " + tmpFile.getAbsolutePath(), passPhrase);
            tmpFile.delete();
            if (success && this.gpg_exitCode != 0) {
                success = false;
            }
        }
        return success;
    }

    public boolean signAndEncrypt(File inFile, String secID, String keyID, String passphrase) {
        boolean success = false;
        success = this.runGnuPG("-u " + secID + " -r " + keyID + " --passphrase-fd 0 -se " + inFile.getAbsolutePath(), passphrase);
        inFile.delete();
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean encrypt(String inStr, String keyID) {
        boolean success = this.runGnuPG(" -r " + keyID + " --encrypt", inStr);
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean decrypt(String inStr, String passPhrase) {
        boolean success = false;
        File tmpFile = this.createTempFile(inStr);
        if (tmpFile != null) {
            success = this.runGnuPG("--passphrase-fd 0 --decrypt " + tmpFile.getAbsolutePath(), passPhrase);
            tmpFile.delete();
            if (success && this.gpg_exitCode != 0) {
                success = false;
            }
        }
        return success;
    }

    public boolean signKey(String keyname, String passphrase) {
        boolean success = this.runGnuPG("--passphrase-fd 0 --yes --sign-key " + keyname, passphrase);
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean decrypt(File inFile, String outFile, String passPhrase) {
        boolean success = false;
        if (inFile != null) {
            if (outFile.indexOf(32) != -1) {
                outFile = "\"" + outFile + "\"";
            }
            if ((success = this.runGnuPG("-o " + outFile + " --passphrase-fd 0" + " --decrypt " + inFile.getAbsolutePath(), passPhrase)) && this.gpg_exitCode != 0) {
                success = false;
            }
        }
        return success;
    }

    public boolean listKeys(String ID) {
        boolean success = this.runGnuPG("--list-keys --with-colons " + ID, null);
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean getKey(String id) {
        boolean success = this.runGnuPG("--armor --export " + id, null);
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean importKeyFile(String keyname) {
        boolean success = this.runGnuPG("--import " + keyname, null);
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean importKey(String key) {
        File tmpFile = this.createTempFile(key);
        boolean success = false;
        if (tmpFile != null) {
            success = this.runGnuPG("--import " + tmpFile, null);
            tmpFile.delete();
            if (success && this.gpg_exitCode != 0) {
                success = false;
            }
        }
        return success;
    }

    public boolean listSecretKeys(String ID) {
        boolean success = this.runGnuPG("--list-secret-keys --with-colons " + ID, null);
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean generateKey(String name, String mail, char[] pwd, String bem) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key-Type: DSA\n Key-Length: 2048\n Subkey-Type: ELG-E\n Subkey-Length: 2048").append("\n Name-Real: ").append(name);
        if (!StringTool.isNothing(bem)) {
            sb.append("\n Name-Comment: ").append(bem);
        }
        sb.append("\n Name-Email: ").append(mail).append("\n Expire-Date: 0").append("\n Passphrase: ").append(pwd).append("\n %commit\n");
        boolean success = this.runGnuPG("--gen-key", sb.toString());
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean changeKeyPassphrase(String key, String oldpwd, String newpwd) {
        StringBuilder sb = new StringBuilder();
        sb.append("passwd\n").append(oldpwd).append("\n").append(newpwd).append("\n").append(newpwd).append("\n").append("quit\n");
        boolean success = this.runGnuPG("--edit-key " + key, sb.toString());
        if (success && this.gpg_exitCode != 0) {
            success = false;
        }
        return success;
    }

    public boolean verify(String signedString, String dataString) {
        boolean success = false;
        File signedFile = this.createTempFile(signedString);
        File dataFile = this.createTempFile(dataString);
        if (signedFile != null && dataFile != null) {
            success = this.runGnuPG("--verify " + signedFile.getAbsolutePath() + " " + dataFile.getAbsolutePath(), null);
            signedFile.delete();
            dataFile.delete();
            if (success && this.gpg_exitCode != 0) {
                success = false;
            }
        }
        return success;
    }

    public boolean verify(String signedString) {
        boolean success = false;
        File signedFile = this.createTempFile(signedString);
        if (signedFile != null) {
            success = this.runGnuPG("--verify " + signedFile.getAbsolutePath(), null);
            signedFile.delete();
            if (success && this.gpg_exitCode != 0) {
                success = false;
            }
        }
        return success;
    }

    public String getResult() {
        return this.gpg_result;
    }

    public String getErrorString() {
        return this.gpg_err;
    }

    public int getExitCode() {
        return this.gpg_exitCode;
    }

    public void runWithCommand(String command) {
        try {
            Process process = Runtime.getRuntime().exec(String.valueOf(this.executable) + " " + command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean runGnuPG(String commandArgs, String inputStr) {
        Process p;
        String fullCommand = String.valueOf(this.createGPGCommand()) + " " + commandArgs;
        if (!this.gpgOK) {
            this.gpg_err = "GnuPG Programm nicht gefunden";
            return false;
        }
        try {
            p = Runtime.getRuntime().exec(fullCommand);
        }
        catch (IOException io) {
            ExHandler.handle(io);
            return false;
        }
        if (inputStr != null) {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            try {
                out.write(inputStr);
                out.close();
            }
            catch (IOException io) {
                System.out.println("Exception at write! " + io.getMessage());
                return false;
            }
        }
        ProcessStreamReader psr_stdout = new ProcessStreamReader(p.getInputStream(), "ERROR");
        ProcessStreamReader psr_stderr = new ProcessStreamReader(p.getErrorStream(), "OUTPUT");
        psr_stdout.start();
        psr_stderr.start();
        try {
            psr_stdout.join();
            psr_stderr.join();
        }
        catch (InterruptedException i) {
            System.out.println("Exception at join! " + i.getMessage());
            return false;
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException i) {
            System.out.println("Exception at waitfor! " + i.getMessage());
            return false;
        }
        try {
            this.gpg_exitCode = p.exitValue();
        }
        catch (IllegalThreadStateException itse) {
            return false;
        }
        this.gpg_result = psr_stdout.getString();
        this.gpg_err = psr_stderr.getString();
        return true;
    }

    private File createTempFile(String inStr) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("YGnuPG", null);
        }
        catch (Exception e) {
            System.out.println("Cannot create temp file " + e.getMessage());
            return null;
        }
        try {
            FileWriter fw = new FileWriter(tmpFile);
            fw.write(inStr);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            tmpFile.delete();
            System.out.println("Cannot write temp file " + e.getMessage());
            return null;
        }
        return tmpFile;
    }

    public GnuPG(String useIdentity) {
        this.identity = useIdentity;
    }

    public boolean isAvailable() {
        return this.gpgOK;
    }

    public static String streamEncoding() {
        OutputStreamWriter out = new OutputStreamWriter(new ByteArrayOutputStream());
        return out.getEncoding();
    }

    @Override
    public Result<byte[]> decrypt(byte[] encrypted) {
        if (this.decrypt(StringTool.createString(encrypted), new String(this.passphrase))) {
            String dec = this.getResult();
            return new Result<byte[]>(StringTool.getBytes(dec));
        }
        return null;
    }

    @Override
    public byte[] sign(byte[] source) {
        if (this.sign(StringTool.createString(source), this.identity, new String(this.passphrase))) {
            return StringTool.getBytes(this.getResult());
        }
        return null;
    }

    @Override
    public byte[] encrypt(byte[] source, String receiverKeyName) {
        if (this.encrypt(StringTool.createString(source), receiverKeyName)) {
            return StringTool.getBytes(this.getResult());
        }
        return null;
    }

    @Override
    public Cryptologist.VERIFY_RESULT verify(byte[] data, byte[] signature, String signerKeyName) {
        if (this.verify(StringTool.createString(data), StringTool.createString(signature))) {
            return Cryptologist.VERIFY_RESULT.OK;
        }
        return Cryptologist.VERIFY_RESULT.BAD_SIGNATURE;
    }

    @Override
    public boolean addCertificate(X509Certificate cert) {
        return false;
    }

    @Override
    public X509Certificate generateCertificate(PublicKey pk, String alias, TimeTool validFrom, TimeTool validUntil) {
        return null;
    }

    @Override
    public KeyPair generateKeys(String alias, char[] pwd, TimeTool validFrom, TimeTool validUntil) {
        return null;
    }

    @Override
    public boolean hasCertificateOf(String alias) {
        return false;
    }

    @Override
    public boolean hasKeyOf(String alias) {
        return false;
    }

    @Override
    public String getUser() {
        return this.identity;
    }

    @Override
    public X509Certificate getCertificate(String alias) {
        return null;
    }

    @Override
    public boolean isFunctional() {
        return false;
    }

    @Override
    public boolean addCertificate(byte[] certEncoded) {
        return false;
    }

    @Override
    public byte[] getCertificateEncoded(String alias) throws CryptologistException {
        return null;
    }

    @Override
    public boolean removeCertificate(String alias) {
        return false;
    }

    @Override
    public void decrypt(InputStream source, OutputStream dest) throws CryptologistException {
    }

    @Override
    public void encrypt(InputStream source, OutputStream dest, String receiverKeyName) throws CryptologistException {
    }

    class ProcessStreamReader
    extends Thread {
        InputStream is;
        String type;
        OutputStream os;
        String fullLine = "";

        ProcessStreamReader(InputStream is, String type) {
            this(is, type, null);
        }

        ProcessStreamReader(InputStream is, String type, OutputStream redirect) {
            this.is = is;
            this.type = type;
            this.os = redirect;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.fullLine = String.valueOf(this.fullLine) + line + "\n";
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        String getString() {
            return this.fullLine;
        }
    }
}

