/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.crypt;

import ch.rgw.crypt.CryptologistException;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public interface Cryptologist {
    public byte[] encrypt(byte[] var1, String var2);

    public void encrypt(InputStream var1, OutputStream var2, String var3) throws CryptologistException;

    public byte[] sign(byte[] var1);

    public Result<byte[]> decrypt(byte[] var1);

    public void decrypt(InputStream var1, OutputStream var2) throws CryptologistException;

    public VERIFY_RESULT verify(byte[] var1, byte[] var2, String var3);

    public boolean hasCertificateOf(String var1);

    public boolean hasKeyOf(String var1);

    public boolean addCertificate(X509Certificate var1);

    public boolean addCertificate(byte[] var1);

    public boolean removeCertificate(String var1);

    public KeyPair generateKeys(String var1, char[] var2, TimeTool var3, TimeTool var4);

    public X509Certificate getCertificate(String var1);

    public X509Certificate generateCertificate(PublicKey var1, String var2, TimeTool var3, TimeTool var4);

    public String getUser();

    public boolean isFunctional();

    public byte[] getCertificateEncoded(String var1) throws CryptologistException;

    public static enum VERIFY_RESULT {
        OK,
        SIGNER_UNKNOWN,
        BAD_SIGNATURE,
        INTERNAL_ERROR;

    }
}

