/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.importer.div.importers;

import ch.elexis.core.data.beans.ContactBean;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.exchange.KontaktMatcher;
import ch.elexis.core.ui.importer.div.importers.Messages;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.hl7.HL7PatientResolver;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.stream.Collectors;

public class ImporterPatientResolver
extends HL7PatientResolver {
    private TimeTool convertTool = new TimeTool();

    public IPatient resolvePatient(String firstname, String lastname, String birthDate, String sender) {
        Patient pat = KontaktMatcher.findPatient((String)lastname, (String)firstname, (String)birthDate, (String)"", (String)"", (String)"", (String)"", (String)"", (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.FAIL);
        if (pat == null) {
            String shortLastname = lastname;
            String shortFirstname = firstname;
            if (lastname.length() > 3) {
                shortLastname = lastname.substring(0, 3);
            }
            if (firstname.length() > 3) {
                shortFirstname = firstname.substring(0, 3);
            }
            pat = KontaktMatcher.findPatient((String)shortLastname, (String)shortFirstname, (String)birthDate, (String)"", (String)"", (String)"", (String)"", (String)"", (KontaktMatcher.CreateMode)KontaktMatcher.CreateMode.FAIL);
        }
        if (pat == null) {
            this.convertTool.set(birthDate);
            String birthStr = this.convertTool.toString(4);
            pat = sender != null ? (Patient)KontaktSelektor.showInSync(Patient.class, (String)Messages.HL7_SelectPatient, (String)(String.valueOf(Messages.HL7_WhoIs) + lastname + " " + firstname + " ," + birthStr + "?\n" + Messages.HL7_Lab + " " + sender)) : (Patient)KontaktSelektor.showInSync(Patient.class, (String)Messages.HL7_SelectPatient, (String)(String.valueOf(Messages.HL7_WhoIs) + lastname + " " + firstname + " ," + birthStr + "?"));
        }
        if (pat != null) {
            return new ContactBean((Kontakt)pat);
        }
        return null;
    }

    public IPatient resolvePatient(String firstname, String lastname, String birthDate) {
        return this.resolvePatient(firstname, lastname, birthDate, null);
    }

    public boolean matchPatient(IPatient patient, String firstname, String lastname, String birthDate) {
        return KontaktMatcher.isSame((IPatient)patient, (String)lastname, (String)firstname, (String)birthDate);
    }

    public IPatient createPatient(String lastName, String firstName, String birthDate, String sex) {
        return new ContactBean((Kontakt)new Patient(lastName, firstName, birthDate, sex));
    }

    public List<? extends IPatient> getPatientById(String patid) {
        Query qbe = new Query(Patient.class);
        qbe.add("PatientNr", "=", StringTool.normalizeCase((String)patid));
        return qbe.execute().stream().map(p -> new ContactBean((Kontakt)p)).collect(Collectors.toList());
    }

    public List<? extends IPatient> findPatientByNameAndBirthdate(String lastName, String firstName, String birthDate) {
        Query qbe = new Query(Patient.class);
        qbe.add("Name", "=", StringTool.normalizeCase((String)lastName));
        qbe.add("Vorname", "=", StringTool.normalizeCase((String)firstName));
        qbe.add("Geburtsdatum", "=", new TimeTool(birthDate).toString(9));
        return qbe.execute().stream().map(p -> new ContactBean((Kontakt)p)).collect(Collectors.toList());
    }
}

