/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.MFN_M08_MF_TEST_NUMERIC;
import ca.uhn.hl7v2.model.v26.segment.MFI;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class MFN_M08
extends AbstractMessage {
    public MFN_M08() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M08(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M08_MF_TEST_NUMERIC.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M08 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFN_M08_MF_TEST_NUMERIC getMF_TEST_NUMERIC() {
        return this.getTyped("MF_TEST_NUMERIC", MFN_M08_MF_TEST_NUMERIC.class);
    }

    public MFN_M08_MF_TEST_NUMERIC getMF_TEST_NUMERIC(int rep) {
        return this.getTyped("MF_TEST_NUMERIC", rep, MFN_M08_MF_TEST_NUMERIC.class);
    }

    public int getMF_TEST_NUMERICReps() {
        return this.getReps("MF_TEST_NUMERIC");
    }

    public List<MFN_M08_MF_TEST_NUMERIC> getMF_TEST_NUMERICAll() throws HL7Exception {
        return this.getAllAsList("MF_TEST_NUMERIC", MFN_M08_MF_TEST_NUMERIC.class);
    }

    public void insertMF_TEST_NUMERIC(MFN_M08_MF_TEST_NUMERIC structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_TEST_NUMERIC", structure, rep);
    }

    public MFN_M08_MF_TEST_NUMERIC insertMF_TEST_NUMERIC(int rep) throws HL7Exception {
        return (MFN_M08_MF_TEST_NUMERIC)super.insertRepetition("MF_TEST_NUMERIC", rep);
    }

    public MFN_M08_MF_TEST_NUMERIC removeMF_TEST_NUMERIC(int rep) throws HL7Exception {
        return (MFN_M08_MF_TEST_NUMERIC)super.removeRepetition("MF_TEST_NUMERIC", rep);
    }
}

