/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.DR;
import ca.uhn.hl7v2.model.v24.datatype.DT;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.SI;
import ca.uhn.hl7v2.model.v24.datatype.XAD;
import ca.uhn.hl7v2.model.v24.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class EDU
extends AbstractSegment {
    public EDU(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 60, new Object[]{this.getMessage()}, "Set ID - EDU");
            this.add(IS.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(360)}, "Academic Degree");
            this.add(DR.class, false, 1, 52, new Object[]{this.getMessage()}, "Academic Degree Program Date Range");
            this.add(DR.class, false, 1, 52, new Object[]{this.getMessage()}, "Academic Degree Program Participation Date Range");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Academic Degree Granted Date");
            this.add(XON.class, false, 1, 250, new Object[]{this.getMessage()}, "School");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "School Type Code");
            this.add(XAD.class, false, 1, 250, new Object[]{this.getMessage()}, "School Address");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EDU - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDEDU() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getEdu1_SetIDEDU() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public IS getAcademicDegree() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public IS getEdu2_AcademicDegree() {
        IS retVal = (IS)this.getTypedField(2, 0);
        return retVal;
    }

    public DR getAcademicDegreeProgramDateRange() {
        DR retVal = (DR)this.getTypedField(3, 0);
        return retVal;
    }

    public DR getEdu3_AcademicDegreeProgramDateRange() {
        DR retVal = (DR)this.getTypedField(3, 0);
        return retVal;
    }

    public DR getAcademicDegreeProgramParticipationDateRange() {
        DR retVal = (DR)this.getTypedField(4, 0);
        return retVal;
    }

    public DR getEdu4_AcademicDegreeProgramParticipationDateRange() {
        DR retVal = (DR)this.getTypedField(4, 0);
        return retVal;
    }

    public DT getAcademicDegreeGrantedDate() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public DT getEdu5_AcademicDegreeGrantedDate() {
        DT retVal = (DT)this.getTypedField(5, 0);
        return retVal;
    }

    public XON getSchool() {
        XON retVal = (XON)this.getTypedField(6, 0);
        return retVal;
    }

    public XON getEdu6_School() {
        XON retVal = (XON)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getSchoolTypeCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getEdu7_SchoolTypeCode() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public XAD getSchoolAddress() {
        XAD retVal = (XAD)this.getTypedField(8, 0);
        return retVal;
    }

    public XAD getEdu8_SchoolAddress() {
        XAD retVal = (XAD)this.getTypedField(8, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new IS(this.getMessage(), new Integer(360));
            }
            case 2: {
                return new DR(this.getMessage());
            }
            case 3: {
                return new DR(this.getMessage());
            }
            case 4: {
                return new DT(this.getMessage());
            }
            case 5: {
                return new XON(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new XAD(this.getMessage());
            }
        }
        return null;
    }
}

