/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContactType implements Enumerator
{
    PERSON(0, "PERSON", "PERSON"),
    ORGANIZATION(1, "ORGANIZATION", "ORGANIZATION"),
    MANDATOR(2, "MANDATOR", ""),
    LABORATORY(3, "LABORATORY", "LABORATORY"),
    PATIENT(4, "PATIENT", "PATIENT"),
    UNKNOWN(9, "UNKNOWN", "UNKNOWN"),
    USER(5, "USER", "USER");

    public static final int PERSON_VALUE = 0;
    public static final int ORGANIZATION_VALUE = 1;
    public static final int MANDATOR_VALUE = 2;
    public static final int LABORATORY_VALUE = 3;
    public static final int PATIENT_VALUE = 4;
    public static final int UNKNOWN_VALUE = 9;
    public static final int USER_VALUE = 5;
    private static final ContactType[] VALUES_ARRAY;
    public static final List<ContactType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContactType[]{PERSON, ORGANIZATION, MANDATOR, LABORATORY, PATIENT, UNKNOWN, USER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContactType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContactType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContactType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContactType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContactType get(int value) {
        switch (value) {
            case 0: {
                return PERSON;
            }
            case 1: {
                return ORGANIZATION;
            }
            case 2: {
                return MANDATOR;
            }
            case 3: {
                return LABORATORY;
            }
            case 4: {
                return PATIENT;
            }
            case 9: {
                return UNKNOWN;
            }
            case 5: {
                return USER;
            }
        }
        return null;
    }

    private ContactType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

