/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.handler;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.ui.documents.Messages;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentExportHandler
extends AbstractHandler
implements IHandler {
    private static Logger logger = LoggerFactory.getLogger(DocumentExportHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection && !((StructuredSelection)selection).isEmpty()) {
            List iDocuments = ((StructuredSelection)selection).toList();
            for (Object documentToExport : iDocuments) {
                if (!(documentToExport instanceof IDocument)) continue;
                this.openExportDialog(shell, (IDocument)documentToExport);
            }
        }
        return null;
    }

    private void openExportDialog(Shell shell, IDocument document) {
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setFilterExtensions(this.createExtensionFilter(document));
        String fname = fd.open();
        if (fname != null) {
            try {
                if (DocumentStoreServiceHolder.getService().saveContentToFile(document, fname) == null) {
                    SWTHelper.showError((String)Messages.DocumentView_exportErrorCaption, (String)Messages.DocumentView_exportErrorEmptyText);
                }
            }
            catch (ElexisException e) {
                logger.error("cannot export file", (Throwable)e);
                SWTHelper.showError((String)Messages.DocumentView_exportErrorCaption, (String)Messages.DocumentView_exportErrorText);
            }
        }
    }

    private String[] createExtensionFilter(IDocument document) {
        ArrayList<String> filterExtensions = new ArrayList<String>();
        if (document.getExtension() != null && !document.getExtension().isEmpty()) {
            filterExtensions.add("*." + document.getExtension());
        }
        filterExtensions.add("*.*");
        return filterExtensions.toArray(new String[0]);
    }
}

