/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.model;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.ICondition;
import ch.elexis.core.findings.fhir.po.model.AbstractFhirPersistentObject;
import ch.elexis.core.findings.util.fhir.accessor.ConditionAccessor;
import ch.rgw.tools.VersionInfo;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class Condition
extends AbstractFhirPersistentObject
implements ICondition {
    protected static final String TABLENAME = "CH_ELEXIS_CORE_FINDINGS_CONDITION";
    protected static final String VERSION = "1.0.0";
    public static final String FLD_PATIENTID = "patientid";
    private ConditionAccessor accessor = new ConditionAccessor();
    protected static final String createDB = "CREATE TABLE CH_ELEXIS_CORE_FINDINGS_CONDITION(ID\t\t\t\t\tVARCHAR(25) PRIMARY KEY,lastupdate \t\tBIGINT,deleted\t\t\tCHAR(1) default '0',patientid\t        VARCHAR(80),content      \t\tTEXT);CREATE INDEX CH_ELEXIS_CORE_FINDINGS_CONDITION_IDX1 ON CH_ELEXIS_CORE_FINDINGS_CONDITION (patientid);INSERT INTO CH_ELEXIS_CORE_FINDINGS_CONDITION (ID, patientid) VALUES ('VERSION','1.0.0');";

    static {
        Condition.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATIENTID, "content"});
        Condition version = Condition.load("VERSION");
        if (version.state() < 2) {
            Condition.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_PATIENTID));
            if (vi.isOlder(VERSION)) {
                version.set(FLD_PATIENTID, VERSION);
            }
        }
    }

    public static Condition load(String id) {
        return new Condition(id);
    }

    protected Condition(String id) {
        super(id);
    }

    public Condition() {
    }

    public String getLabel() {
        return null;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getPatientId() {
        return this.get(FLD_PATIENTID);
    }

    public void setPatientId(String patientId) {
        this.set(FLD_PATIENTID, patientId);
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setPatientId((DomainResource)resource.get(), patientId);
            this.saveResource(resource.get());
        }
    }

    public Optional<LocalDate> getDateRecorded() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getDateRecorded((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setDateRecorded(LocalDate date) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setDateRecorded((DomainResource)resource.get(), date);
            this.saveResource(resource.get());
        }
    }

    public ICondition.ConditionCategory getCategory() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getCategory((DomainResource)resource.get());
        }
        return ICondition.ConditionCategory.UNKNOWN;
    }

    public void setCategory(ICondition.ConditionCategory category) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCategory((DomainResource)resource.get(), category);
            this.saveResource(resource.get());
        }
    }

    public ICondition.ConditionStatus getStatus() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getStatus((DomainResource)resource.get());
        }
        return ICondition.ConditionStatus.UNKNOWN;
    }

    public void setStatus(ICondition.ConditionStatus status) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setStatus((DomainResource)resource.get(), status);
            this.saveResource(resource.get());
        }
    }

    public void setStart(String start) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setStart((DomainResource)resource.get(), start);
            this.saveResource(resource.get());
        }
    }

    public Optional<String> getStart() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getStart((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void setEnd(String end) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setEnd((DomainResource)resource.get(), end);
            this.saveResource(resource.get());
        }
    }

    public Optional<String> getEnd() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getEnd((DomainResource)resource.get());
        }
        return Optional.empty();
    }

    public void addNote(String text) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.addNote((DomainResource)resource.get(), text);
            this.saveResource(resource.get());
        }
    }

    public void removeNote(String text) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.removeNote((DomainResource)resource.get(), text);
            this.saveResource(resource.get());
        }
    }

    public List<String> getNotes() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getNotes((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public List<ICoding> getCoding() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            return this.accessor.getCoding((DomainResource)resource.get());
        }
        return Collections.emptyList();
    }

    public void setCoding(List<ICoding> coding) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent()) {
            this.accessor.setCoding((DomainResource)resource.get(), coding);
            this.saveResource(resource.get());
        }
    }
}

