/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.fhir.po.model;

import ch.elexis.core.findings.IEncounter;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.fhir.po.model.Encounter;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.data.PersistentObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFhirPersistentObject
extends PersistentObject
implements IFinding {
    public static final String FLD_CONTENT = "content";

    public AbstractFhirPersistentObject() {
    }

    public AbstractFhirPersistentObject(String id) {
        super(id);
    }

    public AbstractFhirPersistentObject create() {
        super.create(null);
        return this;
    }

    protected Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    protected Optional<IBaseResource> loadResource() {
        return ModelUtil.loadResource((IFinding)this);
    }

    protected void saveResource(IBaseResource resource) {
        if (resource != null) {
            ModelUtil.saveResource((IBaseResource)resource, (IFinding)this);
        }
    }

    protected Optional<IEncounter> getEncounter(String encounterIdField) {
        Encounter encounter;
        String encounterId = this.get(encounterIdField);
        if (encounterId != null && !encounterId.isEmpty() && (encounter = Encounter.load(encounterId)).exists()) {
            return Optional.of(encounter);
        }
        return Optional.empty();
    }

    protected void setEncounter(IEncounter encounter, String encounterIdField) {
        this.set(encounterIdField, encounter.getId());
        String patientId = encounter.getPatientId();
        if (patientId != null && !patientId.isEmpty()) {
            this.setPatientId(patientId);
        }
    }

    public String getId() {
        return super.getId();
    }

    public Optional<String> getText() {
        Narrative narrative;
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && resource.get() instanceof DomainResource && (narrative = ((DomainResource)resource.get()).getText()) != null && narrative.getDivAsString() != null) {
            return ModelUtil.getNarrativeAsString((Narrative)narrative);
        }
        return Optional.empty();
    }

    public void setText(String text) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && resource.get() instanceof DomainResource) {
            DomainResource domainResource = (DomainResource)resource.get();
            Narrative narrative = domainResource.getText();
            if (narrative == null) {
                narrative = new Narrative();
            }
            ModelUtil.setNarrativeFromString((Narrative)narrative, (String)text);
            domainResource.setText(narrative);
            this.saveResource((IBaseResource)domainResource);
        }
    }

    public void addStringExtension(String theUrl, String theValue) {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && resource.get() instanceof DomainResource) {
            DomainResource domainResource = (DomainResource)resource.get();
            Extension extension = new Extension(theUrl);
            extension.setValue((Type)new StringType().setValue((Object)theValue));
            domainResource.addExtension(extension);
            this.saveResource((IBaseResource)domainResource);
        }
    }

    public Map<String, String> getStringExtensions() {
        Optional<IBaseResource> resource = this.loadResource();
        if (resource.isPresent() && resource.get() instanceof DomainResource) {
            List extensions = ((DomainResource)resource.get()).getExtension();
            return extensions.stream().filter(extension -> extension.getValue() instanceof StringType).collect(Collectors.toMap(extension -> extension.getUrl(), extension -> ((StringType)extension.getValue()).getValueAsString()));
        }
        return Collections.emptyMap();
    }

    public IFinding.RawContentFormat getRawContentFormat() {
        return IFinding.RawContentFormat.FHIR_JSON;
    }

    public String getRawContent() {
        return this.get(FLD_CONTENT);
    }

    public void setRawContent(String content) {
        this.set(FLD_CONTENT, content);
    }
}

