/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.segment.SAC;
import ca.uhn.hl7v2.model.v25.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class EAC_U07_SPECIMEN_CONTAINER
extends AbstractGroup {
    public EAC_U07_SPECIMEN_CONTAINER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SAC.class, true, false, false);
            this.add(SPM.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating EAC_U07_SPECIMEN_CONTAINER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public SAC getSAC() {
        SAC retVal = this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public SPM getSPM() {
        SPM retVal = this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public SPM getSPM(int rep) {
        SPM retVal = this.getTyped("SPM", rep, SPM.class);
        return retVal;
    }

    public int getSPMReps() {
        return this.getReps("SPM");
    }

    public List<SPM> getSPMAll() throws HL7Exception {
        return this.getAllAsList("SPM", SPM.class);
    }

    public void insertSPM(SPM structure, int rep) throws HL7Exception {
        super.insertRepetition("SPM", structure, rep);
    }

    public SPM insertSPM(int rep) throws HL7Exception {
        return (SPM)super.insertRepetition("SPM", rep);
    }

    public SPM removeSPM(int rep) throws HL7Exception {
        return (SPM)super.removeRepetition("SPM", rep);
    }
}

