/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.RPI_I01_GT1IN1IN2IN3;
import ca.uhn.hl7v2.model.v231.group.RPI_I01_PRDCTD;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NK1;
import ca.uhn.hl7v2.model.v231.segment.NTE;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RPI_I01
extends AbstractMessage {
    public RPI_I01() {
        this(new DefaultModelClassFactory());
    }

    public RPI_I01(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(RPI_I01_PRDCTD.class, true, true);
            this.add(PID.class, true, false);
            this.add(NK1.class, false, true);
            this.add(RPI_I01_GT1IN1IN2IN3.class, false, false);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPI_I01 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public RPI_I01_PRDCTD getPRDCTD() {
        return this.getTyped("PRDCTD", RPI_I01_PRDCTD.class);
    }

    public RPI_I01_PRDCTD getPRDCTD(int rep) {
        return this.getTyped("PRDCTD", rep, RPI_I01_PRDCTD.class);
    }

    public int getPRDCTDReps() {
        return this.getReps("PRDCTD");
    }

    public List<RPI_I01_PRDCTD> getPRDCTDAll() throws HL7Exception {
        return this.getAllAsList("PRDCTD", RPI_I01_PRDCTD.class);
    }

    public void insertPRDCTD(RPI_I01_PRDCTD structure, int rep) throws HL7Exception {
        super.insertRepetition("PRDCTD", structure, rep);
    }

    public RPI_I01_PRDCTD insertPRDCTD(int rep) throws HL7Exception {
        return (RPI_I01_PRDCTD)super.insertRepetition("PRDCTD", rep);
    }

    public RPI_I01_PRDCTD removePRDCTD(int rep) throws HL7Exception {
        return (RPI_I01_PRDCTD)super.removeRepetition("PRDCTD", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public RPI_I01_GT1IN1IN2IN3 getGT1IN1IN2IN3() {
        return this.getTyped("GT1IN1IN2IN3", RPI_I01_GT1IN1IN2IN3.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

