/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v23.group.RQA_I09_AUTHORIZATION;
import ca.uhn.hl7v2.model.v23.group.RQA_I09_GUARANTOR_INSURANCE;
import ca.uhn.hl7v2.model.v23.group.RQA_I09_PROCEDURE;
import ca.uhn.hl7v2.model.v23.group.RQA_I09_PROVIDER;
import ca.uhn.hl7v2.model.v23.group.RQA_I09_RESULTS;
import ca.uhn.hl7v2.model.v23.group.RQA_I09_VISIT;
import ca.uhn.hl7v2.model.v23.segment.ACC;
import ca.uhn.hl7v2.model.v23.segment.AL1;
import ca.uhn.hl7v2.model.v23.segment.DG1;
import ca.uhn.hl7v2.model.v23.segment.DRG;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NK1;
import ca.uhn.hl7v2.model.v23.segment.NTE;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.model.v23.segment.RF1;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class RQA_I09
extends AbstractMessage {
    public RQA_I09() {
        this(new DefaultModelClassFactory());
    }

    public RQA_I09(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(RF1.class, false, false);
            this.add(RQA_I09_AUTHORIZATION.class, false, false);
            this.add(RQA_I09_PROVIDER.class, true, true);
            this.add(PID.class, true, false);
            this.add(NK1.class, false, true);
            this.add(RQA_I09_GUARANTOR_INSURANCE.class, false, false);
            this.add(ACC.class, false, false);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, true);
            this.add(AL1.class, false, true);
            this.add(RQA_I09_PROCEDURE.class, false, true);
            this.add(RQA_I09_RESULTS.class, false, true);
            this.add(RQA_I09_VISIT.class, false, false);
            this.add(NTE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RQA_I09 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public RF1 getRF1() {
        return this.getTyped("RF1", RF1.class);
    }

    public RQA_I09_AUTHORIZATION getAUTHORIZATION() {
        return this.getTyped("AUTHORIZATION", RQA_I09_AUTHORIZATION.class);
    }

    public RQA_I09_PROVIDER getPROVIDER() {
        return this.getTyped("PROVIDER", RQA_I09_PROVIDER.class);
    }

    public RQA_I09_PROVIDER getPROVIDER(int rep) {
        return this.getTyped("PROVIDER", rep, RQA_I09_PROVIDER.class);
    }

    public int getPROVIDERReps() {
        return this.getReps("PROVIDER");
    }

    public List<RQA_I09_PROVIDER> getPROVIDERAll() throws HL7Exception {
        return this.getAllAsList("PROVIDER", RQA_I09_PROVIDER.class);
    }

    public void insertPROVIDER(RQA_I09_PROVIDER structure, int rep) throws HL7Exception {
        super.insertRepetition("PROVIDER", structure, rep);
    }

    public RQA_I09_PROVIDER insertPROVIDER(int rep) throws HL7Exception {
        return (RQA_I09_PROVIDER)super.insertRepetition("PROVIDER", rep);
    }

    public RQA_I09_PROVIDER removePROVIDER(int rep) throws HL7Exception {
        return (RQA_I09_PROVIDER)super.removeRepetition("PROVIDER", rep);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public NK1 getNK1() {
        return this.getTyped("NK1", NK1.class);
    }

    public NK1 getNK1(int rep) {
        return this.getTyped("NK1", rep, NK1.class);
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public RQA_I09_GUARANTOR_INSURANCE getGUARANTOR_INSURANCE() {
        return this.getTyped("GUARANTOR_INSURANCE", RQA_I09_GUARANTOR_INSURANCE.class);
    }

    public ACC getACC() {
        return this.getTyped("ACC", ACC.class);
    }

    public DG1 getDG1() {
        return this.getTyped("DG1", DG1.class);
    }

    public DG1 getDG1(int rep) {
        return this.getTyped("DG1", rep, DG1.class);
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        return this.getTyped("DRG", DRG.class);
    }

    public DRG getDRG(int rep) {
        return this.getTyped("DRG", rep, DRG.class);
    }

    public int getDRGReps() {
        return this.getReps("DRG");
    }

    public List<DRG> getDRGAll() throws HL7Exception {
        return this.getAllAsList("DRG", DRG.class);
    }

    public void insertDRG(DRG structure, int rep) throws HL7Exception {
        super.insertRepetition("DRG", structure, rep);
    }

    public DRG insertDRG(int rep) throws HL7Exception {
        return (DRG)super.insertRepetition("DRG", rep);
    }

    public DRG removeDRG(int rep) throws HL7Exception {
        return (DRG)super.removeRepetition("DRG", rep);
    }

    public AL1 getAL1() {
        return this.getTyped("AL1", AL1.class);
    }

    public AL1 getAL1(int rep) {
        return this.getTyped("AL1", rep, AL1.class);
    }

    public int getAL1Reps() {
        return this.getReps("AL1");
    }

    public List<AL1> getAL1All() throws HL7Exception {
        return this.getAllAsList("AL1", AL1.class);
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public RQA_I09_PROCEDURE getPROCEDURE() {
        return this.getTyped("PROCEDURE", RQA_I09_PROCEDURE.class);
    }

    public RQA_I09_PROCEDURE getPROCEDURE(int rep) {
        return this.getTyped("PROCEDURE", rep, RQA_I09_PROCEDURE.class);
    }

    public int getPROCEDUREReps() {
        return this.getReps("PROCEDURE");
    }

    public List<RQA_I09_PROCEDURE> getPROCEDUREAll() throws HL7Exception {
        return this.getAllAsList("PROCEDURE", RQA_I09_PROCEDURE.class);
    }

    public void insertPROCEDURE(RQA_I09_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROCEDURE", structure, rep);
    }

    public RQA_I09_PROCEDURE insertPROCEDURE(int rep) throws HL7Exception {
        return (RQA_I09_PROCEDURE)super.insertRepetition("PROCEDURE", rep);
    }

    public RQA_I09_PROCEDURE removePROCEDURE(int rep) throws HL7Exception {
        return (RQA_I09_PROCEDURE)super.removeRepetition("PROCEDURE", rep);
    }

    public RQA_I09_RESULTS getRESULTS() {
        return this.getTyped("RESULTS", RQA_I09_RESULTS.class);
    }

    public RQA_I09_RESULTS getRESULTS(int rep) {
        return this.getTyped("RESULTS", rep, RQA_I09_RESULTS.class);
    }

    public int getRESULTSReps() {
        return this.getReps("RESULTS");
    }

    public List<RQA_I09_RESULTS> getRESULTSAll() throws HL7Exception {
        return this.getAllAsList("RESULTS", RQA_I09_RESULTS.class);
    }

    public void insertRESULTS(RQA_I09_RESULTS structure, int rep) throws HL7Exception {
        super.insertRepetition("RESULTS", structure, rep);
    }

    public RQA_I09_RESULTS insertRESULTS(int rep) throws HL7Exception {
        return (RQA_I09_RESULTS)super.insertRepetition("RESULTS", rep);
    }

    public RQA_I09_RESULTS removeRESULTS(int rep) throws HL7Exception {
        return (RQA_I09_RESULTS)super.removeRepetition("RESULTS", rep);
    }

    public RQA_I09_VISIT getVISIT() {
        return this.getTyped("VISIT", RQA_I09_VISIT.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public NTE getNTE(int rep) {
        return this.getTyped("NTE", rep, NTE.class);
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }
}

