/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class ColumnDeleteEvent
extends ColumnStructuralChangeEvent {
    public ColumnDeleteEvent(ILayer layer, int columnPosition) {
        this(layer, new Range(columnPosition, columnPosition + 1));
    }

    public ColumnDeleteEvent(ILayer layer, Range ... columnPositionRanges) {
        super(layer, columnPositionRanges);
    }

    public ColumnDeleteEvent(ILayer layer, Collection<Range> columnPositionRanges) {
        super(layer, columnPositionRanges);
    }

    protected ColumnDeleteEvent(ColumnStructuralChangeEvent event) {
        super(event);
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        ArrayList<StructuralDiff> columnDiffs = new ArrayList<StructuralDiff>();
        for (Range range : this.getColumnPositionRanges()) {
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, range, new Range(range.start, range.start)));
        }
        return columnDiffs;
    }

    @Override
    public ILayerEvent cloneEvent() {
        return new ColumnDeleteEvent(this);
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        return true;
    }
}

