/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.Anwender;
import ch.elexis.data.Artikel;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.data.User;
import ch.rgw.tools.TimeTool;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public class MedicationTableViewerItem {
    private static ExecutorService executorService = Executors.newFixedThreadPool(8);
    private StructuredViewer viewer;
    private Prescription prescription;
    private String artikelId;
    private String artikelStoreToString;
    private String dateFrom;
    private String dateUntil;
    private String dosis;
    private String remark;
    private String disposalComment;
    private String rezeptId;
    private String sortOrder;
    private String prescriptorId;
    private String artikelLabel;
    private Object lastDisposed;
    private String prescriptorLabel;
    private String stopReason;
    private Image image;
    private boolean resolved = false;
    private boolean resolving = false;
    private Date endTime;

    private MedicationTableViewerItem(Prescription p, StructuredViewer viewer) {
        this.viewer = viewer;
        String[] values = p.get(false, new String[]{"ArtikelID", "Artikel", "Dosis", "Bemerkung", "RezeptID", "sortOrder", "prescriptor"});
        this.prescription = p;
        this.artikelId = values[0];
        this.artikelStoreToString = values[1];
        this.dosis = values[2];
        this.remark = values[3];
        this.rezeptId = values[4];
        this.sortOrder = values[5];
        this.prescriptorId = values[6];
        this.dateFrom = p.getBeginTime();
        this.dateUntil = p.getEndTime();
        this.endTime = new TimeTool(this.dateUntil).getTime();
    }

    public static List<MedicationTableViewerItem> createFromPrescriptionList(List<Prescription> prescriptionList, StructuredViewer viewer) {
        List<MedicationTableViewerItem> collect = prescriptionList.parallelStream().map(p -> new MedicationTableViewerItem((Prescription)p, viewer)).collect(Collectors.toList());
        return collect;
    }

    public String getId() {
        return this.prescription.getId();
    }

    public String getBeginDate() {
        return this.dateFrom;
    }

    public String getEndDate() {
        return this.dateUntil;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date time) {
        this.endTime = time;
    }

    public String getDosis() {
        return this.dosis;
    }

    public Prescription getPrescription() {
        return this.prescription;
    }

    public String getStopReason() {
        if (this.stopReason == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.stopReason != null ? this.stopReason : "...";
    }

    public String getRemark() {
        return this.remark;
    }

    public String getDisposalComment() {
        if (this.disposalComment == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.disposalComment != null ? this.disposalComment : "...";
    }

    public boolean isFixedMediation() {
        return this.prescription.isFixedMedication(this.rezeptId, this.dateUntil);
    }

    public IPersistentObject getLastDisposed() {
        if (this.lastDisposed == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.lastDisposed instanceof IPersistentObject ? (IPersistentObject)this.lastDisposed : null;
    }

    public EntryType getEntryType() {
        return this.prescription.getEntryType();
    }

    public boolean isReserveMedication() {
        return this.prescription.isReserveMedication();
    }

    public String getArtikelLabel() {
        if (this.artikelLabel == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.artikelLabel != null ? this.artikelLabel : "...";
    }

    public void setOrder(String i) {
        this.sortOrder = i;
        this.prescription.set("sortOrder", i);
    }

    public String getOrder() {
        return this.sortOrder;
    }

    public boolean isStopped() {
        return this.dateUntil != null && !this.dateUntil.isEmpty();
    }

    public String getPrescriptorLabel() {
        if (this.prescriptorLabel == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.prescriptorLabel != null ? this.prescriptorLabel : "...";
    }

    public Image getImage() {
        if (this.image == null && !this.resolved && !this.resolving) {
            this.resolving = true;
            executorService.execute(new ResolveLazyFieldsRunnable(this.viewer, this));
        }
        return this.image != null ? this.image : Images.IMG_EMPTY_TRANSPARENT.getImage();
    }

    public void resolve() {
        new ResolveLazyFieldsRunnable(null, this).run();
    }

    private static class ResolveLazyFieldsRunnable
    implements Runnable {
        private MedicationTableViewerItem item;
        private StructuredViewer viewer;

        public ResolveLazyFieldsRunnable(StructuredViewer viewer, MedicationTableViewerItem item) {
            this.item = item;
            this.viewer = viewer;
        }

        @Override
        public void run() {
            this.resolveImage();
            this.resolveArticleLabel();
            this.resolveLastDisposed();
            this.resolveStopReason();
            this.resolvePrescriptorLabel();
            this.resolveDisposalComment();
            this.item.resolved = true;
            this.item.resolving = false;
            this.updateViewer();
        }

        private void updateViewer() {
            Control control;
            if (this.viewer != null && (control = this.viewer.getControl()) != null && !control.isDisposed()) {
                this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!control.isDisposed() && control.isVisible()) {
                            viewer.update((Object)item, null);
                        }
                    }
                });
            }
        }

        private void resolveArticleLabel() {
            if (this.item.artikelStoreToString != null && !this.item.artikelStoreToString.isEmpty()) {
                Artikel artikel = (Artikel)CoreHub.poFactory.createFromString(this.item.artikelStoreToString);
                if (artikel == null) {
                    this.item.artikelLabel = "?";
                } else {
                    this.item.artikelLabel = artikel.getLabel();
                }
            } else if (this.item.artikelId != null && !this.item.artikelId.isEmpty()) {
                Artikel artikel = Artikel.load((String)this.item.artikelId);
                if (artikel != null && artikel.exists()) {
                    this.item.artikelLabel = artikel.getLabel();
                } else {
                    this.item.artikelLabel = "?";
                }
            } else {
                this.item.artikelLabel = "?";
            }
        }

        private void resolveImage() {
            EntryType et = this.item.prescription.getEntryType();
            switch (et) {
                case FIXED_MEDICATION: {
                    this.item.image = Images.IMG_FIX_MEDI.getImage();
                    break;
                }
                case RESERVE_MEDICATION: {
                    this.item.image = Images.IMG_RESERVE_MEDI.getImage();
                    break;
                }
                case SYMPTOMATIC_MEDICATION: {
                    this.item.image = Images.IMG_SYMPTOM_MEDI.getImage();
                    break;
                }
                case SELF_DISPENSED: {
                    if (this.item.prescription.isApplied().booleanValue()) {
                        this.item.image = Images.IMG_SYRINGE.getImage();
                        break;
                    }
                    this.item.image = Images.IMG_VIEW_CONSULTATION_DETAIL.getImage();
                    break;
                }
                case RECIPE: {
                    this.item.image = Images.IMG_VIEW_RECIPES.getImage();
                    break;
                }
                default: {
                    this.item.image = Images.IMG_EMPTY_TRANSPARENT.getImage();
                }
            }
        }

        private void resolveLastDisposed() {
            IPersistentObject ld = this.item.prescription.getLastDisposed(this.item.rezeptId);
            if (ld == null) {
                this.item.lastDisposed = "";
            } else {
                this.item.lastDisposed = ld;
            }
        }

        private void resolveStopReason() {
            String reason = this.item.prescription.getStopReason();
            if (reason != null) {
                this.item.stopReason = reason;
            } else {
                this.item.stopReason = "";
            }
        }

        private void resolvePrescriptorLabel() {
            this.item.prescriptorLabel = "";
            if (this.item.prescriptorId != null && !this.item.prescriptorId.isEmpty()) {
                Anwender prescriptor;
                Query query = new Query(User.class);
                query.add("KONTAKT_ID", "=", this.item.prescriptorId);
                List users = query.execute();
                if (!users.isEmpty()) {
                    this.item.prescriptorLabel = ((User)users.get(0)).getId();
                }
                if ((this.item.prescriptorLabel == null || this.item.prescriptorLabel.isEmpty()) && (prescriptor = Anwender.load((String)this.item.prescriptorId)) != null && prescriptor.exists()) {
                    this.item.prescriptorLabel = prescriptor.getKuerzel();
                }
            }
        }

        private void resolveDisposalComment() {
            String comment = this.item.prescription.getDisposalComment();
            if (comment != null) {
                this.item.disposalComment = comment;
            } else {
                this.item.disposalComment = "";
            }
        }
    }
}

