/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.billing;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.interfaces.IVerrechnetAdjuster;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.data.Artikel;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.Prescription;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PrescriptionVerrechnetAdjuster
implements IVerrechnetAdjuster {
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public void adjust(final Verrechnet verrechnet) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
                if (verrechenbar instanceof Artikel) {
                    Artikel article = (Artikel)verrechenbar;
                    Optional patientOpt = PrescriptionVerrechnetAdjuster.this.getPatient(verrechnet);
                    if (patientOpt.isPresent()) {
                        Query query = new Query(Prescription.class);
                        query.add("Artikel", "=", article.storeToString());
                        query.add("PatientID", "=", ((Patient)patientOpt.get()).getId());
                        List existingPrescriptions = query.execute();
                        boolean dispensationExists = false;
                        if (!existingPrescriptions.isEmpty()) {
                            for (Prescription prescription : existingPrescriptions) {
                                TimeTool verrechnetDate;
                                TimeTool prescriptionDate;
                                if (prescription.getEntryType() != EntryType.SELF_DISPENSED || !(prescriptionDate = new TimeTool(prescription.getBeginDate())).isSameDay(verrechnetDate = PrescriptionVerrechnetAdjuster.this.getVerrechnetDate(verrechnet))) continue;
                                dispensationExists = true;
                                break;
                            }
                        }
                        if (!dispensationExists) {
                            PrescriptionVerrechnetAdjuster.this.createDispensationPrescription(article, (Patient)patientOpt.get(), verrechnet);
                            ElexisEventDispatcher.reload(Prescription.class);
                        }
                    }
                }
            }
        });
    }

    private Optional<Patient> getPatient(Verrechnet verrrechnet) {
        Fall fall;
        Konsultation konsultation = verrrechnet.getKons();
        if (konsultation != null && (fall = konsultation.getFall()) != null) {
            return Optional.of(fall.getPatient());
        }
        return Optional.empty();
    }

    private TimeTool getVerrechnetDate(Verrechnet verrrechnet) {
        Konsultation konsultation = verrrechnet.getKons();
        return new TimeTool(konsultation.getDatum());
    }

    private Prescription createDispensationPrescription(Artikel article, Patient patient, Verrechnet verrechnet) {
        Prescription prescription = new Prescription(article, patient, "", "");
        prescription.setExtInfoStoredObjectByKey((Object)"verrechnetId", (Object)verrechnet.getId());
        verrechnet.setDetail("prescriptionId", prescription.getId());
        prescription.setEntryType(EntryType.SELF_DISPENSED);
        prescription.stop(null);
        return prescription;
    }

    public void adjustGetNettoPreis(Verrechnet verrechnet, Money price) {
    }
}

