/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log {
    public static final int NOTHING = 0;
    public static final int FATALS = 1;
    public static final int ERRORS = 2;
    public static final int WARNINGS = 3;
    public static final int INFOS = 4;
    public static final int DEBUGMSG = 5;
    public static final int TRACE = 6;
    public static final int SYNCMARK = -1;
    private static Logger l;
    private static boolean printedConf;

    private static void internalLogging(Level level, String msg2) {
        if (level == Level.SEVERE) {
            l.error(msg2);
        } else if (level == Level.WARNING) {
            l.warn(msg2);
        } else if (level == Level.INFO) {
            l.info(msg2);
        } else if (level == Level.WARNING) {
            l.warn(msg2);
        } else {
            l.debug(msg2);
        }
    }

    public static Log get(String name) {
        l = LoggerFactory.getLogger((String)name);
        return new Log();
    }

    public void log(String message, int level) {
        Log.internalLogging(this.translate(level), message);
    }

    public void log(Level level, String message) {
        Log.internalLogging(level, message);
    }

    private Level translate(int logLevel) {
        switch (logLevel) {
            case 0: {
                return Level.FINEST;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.SEVERE;
            }
            case 3: {
                return Level.WARNING;
            }
            case 4: {
                return Level.INFO;
            }
            case 5: {
                return Level.FINE;
            }
            case 6: {
                return Level.ALL;
            }
            case -1: {
                return Level.ALL;
            }
        }
        return Level.ALL;
    }
}

