/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.artikel;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.FavoritenCTabItem;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.core.ui.views.artikel.Messages;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.rgw.tools.ExHandler;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ArtikelView
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    private static final String KEY_CE = "ce";
    private static final String KEY_DETAIL = "detail";
    public static final String ID = "ch.elexis.artikelview";
    private CTabFolder ctab;
    private IAction importAction;
    private ViewMenus viewmenus;
    private Hashtable<String, ImporterPage> importers;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.ctab = new CTabFolder(parent, 0);
        this.importers = new Hashtable();
        new FavoritenCTabItem(this.ctab, 0);
        this.addPagesFor("ch.elexis.core.ui.Verrechnungscode");
        if (this.ctab.getItemCount() > 0) {
            this.ctab.setSelection(0);
        }
        this.ctab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem selected = ArtikelView.this.ctab.getSelection();
                if (selected instanceof FavoritenCTabItem) {
                    return;
                }
                if (selected != null) {
                    String t = selected.getText();
                    MasterDetailsPage page = (MasterDetailsPage)selected.getControl();
                    if (page == null) {
                        try {
                            IDetailDisplay det = (IDetailDisplay)selected.getData(ArtikelView.KEY_DETAIL);
                            IConfigurationElement ce = (IConfigurationElement)selected.getData(ArtikelView.KEY_CE);
                            CodeSelectorFactory cs = (CodeSelectorFactory)ce.createExecutableExtension("CodeSelectorFactory");
                            String a = ce.getAttribute("ImporterClass");
                            ImporterPage ip = null;
                            if (a != null && (ip = (ImporterPage)ce.createExecutableExtension("ImporterClass")) != null) {
                                ArtikelView.this.importers.put(det.getTitle(), ip);
                            }
                            page = new MasterDetailsPage((Composite)ArtikelView.this.ctab, cs, det);
                            selected.setControl((Control)page);
                            selected.setData((Object)det);
                        }
                        catch (Exception ex) {
                            ExHandler.handle((Throwable)ex);
                            return;
                        }
                    }
                    ArtikelView.this.importAction.setEnabled(ArtikelView.this.importers.get(t) != null);
                    ViewerConfigurer vc = page.cv.getConfigurer();
                    vc.getControlFieldProvider().setFocus();
                }
            }
        });
        this.makeActions();
        this.viewmenus = new ViewMenus(this.getViewSite());
        this.viewmenus.createMenu(this.importAction);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
    }

    private void makeActions() {
        this.importAction = new Action(Messages.ArtikelView_importAction){

            public void run() {
                ImporterPage top;
                CTabItem it = ArtikelView.this.ctab.getSelection();
                if (it != null && (top = (ImporterPage)ArtikelView.this.importers.get(it.getText())) != null) {
                    ImportDialog dlg = new ImportDialog(ArtikelView.this.getViewSite().getShell(), top);
                    dlg.create();
                    dlg.setTitle(top.getTitle());
                    dlg.setMessage(top.getDescription());
                    dlg.getShell().setText(Messages.ArtikelView_importCaption);
                    if (dlg.open() == 0) {
                        top.run(false);
                    }
                }
            }
        };
    }

    private void addPagesFor(String point) {
        List list = Extensions.getExtensions((String)point);
        boolean headerDone = false;
        int i = 0;
        while (i < list.size()) {
            IConfigurationElement ce = (IConfigurationElement)list.get(i);
            try {
                if ("Artikel".equals(ce.getName())) {
                    IDetailDisplay d;
                    if (!headerDone) {
                        d = (IDetailDisplay)ce.createExecutableExtension("CodeDetailDisplay");
                        String a = ce.getAttribute("ImporterClass");
                        ImporterPage ip = null;
                        if (a != null && (ip = (ImporterPage)ce.createExecutableExtension("ImporterClass")) != null) {
                            this.importers.put(d.getTitle(), ip);
                        }
                        CodeSelectorFactory csf = (CodeSelectorFactory)ce.createExecutableExtension("CodeSelectorFactory");
                        MasterDetailsPage page = new MasterDetailsPage((Composite)this.ctab, csf, d);
                        CTabItem ct = new CTabItem(this.ctab, 0);
                        ct.setText(d.getTitle());
                        ct.setControl((Control)page);
                        ct.setData((Object)d);
                        page.sash.setWeights(new int[]{30, 70});
                        headerDone = true;
                    } else {
                        d = (IDetailDisplay)ce.createExecutableExtension("CodeDetailDisplay");
                        CTabItem ct = new CTabItem(this.ctab, 0);
                        ct.setText(d.getTitle());
                        ct.setData(KEY_CE, (Object)ce);
                        ct.setData(KEY_DETAIL, (Object)d);
                    }
                }
            }
            catch (Exception ex) {
                MessageBox mb = new MessageBox(this.getViewSite().getShell(), 33);
                mb.setText(Messages.ArtikelView_errorCaption);
                mb.setMessage(String.valueOf(Messages.ArtikelView_errorText) + ce.getName() + ":\n" + ex.getLocalizedMessage());
                mb.open();
            }
            ++i;
        }
    }

    public void setFocus() {
        if (this.ctab.getItemCount() > 0) {
            this.ctab.setFocus();
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        if (this.ctab != null && !this.ctab.isDisposed()) {
            CTabItem[] cTabItemArray = this.ctab.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem ct = cTabItemArray[n2];
                MasterDetailsPage page = (MasterDetailsPage)ct.getControl();
                page.cv.getConfigurer().getContentProvider().stopListening();
                page.dispose();
                ++n2;
            }
        }
    }

    @Override
    public void activation(boolean mode) {
        CTabItem selected = this.ctab.getSelection();
        if (selected instanceof FavoritenCTabItem) {
            return;
        }
        if (selected != null) {
            MasterDetailsPage page = (MasterDetailsPage)selected.getControl();
            ViewerConfigurer vc = page.cv.getConfigurer();
            if (mode) {
                vc.getControlFieldProvider().setFocus();
            } else {
                vc.getControlFieldProvider().clearValues();
            }
        }
    }

    @Override
    public void visible(boolean mode) {
        System.out.println(String.valueOf(this.getClass().getName()) + " visible " + mode);
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    private class ImportDialog
    extends TitleAreaDialog {
        ImporterPage importer;

        public ImportDialog(Shell parentShell, ImporterPage i) {
            super(parentShell);
            this.importer = i;
        }

        protected Control createDialogArea(Composite parent) {
            return this.importer.createPage(parent);
        }

        protected void okPressed() {
            this.importer.collect();
            super.okPressed();
        }
    }

    class MasterDetailsPage
    extends Composite {
        SashForm sash;
        CommonViewer cv;
        IDetailDisplay detailDisplay;
        ElexisEventListenerImpl eeli_div;

        MasterDetailsPage(Composite parent, CodeSelectorFactory master, IDetailDisplay detail) {
            super(parent, 0);
            this.eeli_div = new ElexisUiEventListenerImpl(detail.getElementClass(), 16){

                @Override
                public void runInUi(ElexisEvent ev) {
                    MasterDetailsPage.this.detailDisplay.display(ev.getObject());
                }
            };
            this.setLayout((Layout)new FillLayout());
            this.sash = new SashForm((Composite)this, 0);
            this.cv = new CommonViewer();
            this.cv.create(master.createViewerConfigurer(this.cv), (Composite)this.sash, 0, ArtikelView.this.getViewSite());
            detail.createDisplay((Composite)this.sash, ArtikelView.this.getViewSite());
            this.cv.getConfigurer().getContentProvider().startListening();
            this.detailDisplay = detail;
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_div});
        }

        public void dispose() {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_div});
        }
    }
}

