/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.artikel;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.commands.EditEigenartikelUi;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.views.artikel.Messages;
import ch.elexis.data.Artikel;
import ch.elexis.data.PersistentObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ArtikelContextMenu {
    private IAction deleteAction;
    private IAction createAction;
    private IAction editAction;
    CommonViewer cv;
    ArtikelDetailDisplay add;
    ArtikelMenuListener menuListener = new ArtikelMenuListener();
    MenuManager menu;
    ArrayList<IAction> actions = new ArrayList();

    public ArtikelContextMenu(Artikel template, CommonViewer cv) {
        this.cv = cv;
        this.makeActions(template);
        this.actions.add(this.deleteAction);
        this.actions.add(this.createAction);
        this.actions.add(this.editAction);
        this.menu = new MenuManager();
        this.menu.addMenuListener((IMenuListener)this.menuListener);
        cv.setContextMenu(this.menu);
    }

    public void addAction(IAction ac) {
        this.actions.add(ac);
    }

    public void removeAction(IAction ac) {
        this.actions.remove(ac);
    }

    public ArtikelContextMenu(Artikel template, CommonViewer cv, ArtikelDetailDisplay add) {
        this(template, cv);
        this.add = add;
    }

    private void makeActions(final Artikel art) {
        this.deleteAction = new Action(Messages.ArtikelContextMenu_deleteAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(String.valueOf(artikel.getClass().getName()) + Messages.ArtikelContextMenu_deleteActionToolTip);
            }

            public void run() {
                Artikel act = (Artikel)ElexisEventDispatcher.getSelected(art.getClass());
                if (MessageDialog.openConfirm((Shell)ArtikelContextMenu.this.cv.getViewerWidget().getControl().getShell(), (String)Messages.ArtikelContextMenu_deleteActionConfirmCaption, (String)MessageFormat.format(Messages.ArtikelContextMenu_deleteConfirmBody, act.getName()))) {
                    act.delete();
                    ArtikelContextMenu.this.cv.getConfigurer().getControlFieldProvider().fireChangedEvent();
                    ArtikelContextMenu.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
        this.createAction = new Action(Messages.ArtikelContextMenu_newAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText(Messages.ArtikelContextMenu_newActionTooltip);
            }

            public void run() {
                InputDialog inp = new InputDialog(ArtikelContextMenu.this.cv.getViewerWidget().getControl().getShell(), String.valueOf(art.getClass().getName()) + Messages.ArtikelContextMenu_create, Messages.ArtikelContextMenu_pleaseEnterNameForArticle, "", null);
                if (inp.open() == 0) {
                    String name = inp.getValue();
                    Artikel n = new Artikel(name, art.getCodeSystemName(), "");
                    if (ArtikelContextMenu.this.add == null) {
                        EditEigenartikelUi.executeWithParams((PersistentObject)n);
                    } else {
                        ArtikelContextMenu.this.add.show(n);
                    }
                }
            }
        };
        this.editAction = new Action(Messages.ArtikelContextMenu_propertiesAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.ArtikelContextMenu_propertiesTooltip);
            }

            public void run() {
                Artikel n = (Artikel)ElexisEventDispatcher.getSelected(art.getClass());
                if (ArtikelContextMenu.this.add == null) {
                    EditEigenartikelUi.executeWithParams((PersistentObject)n);
                } else {
                    ArtikelContextMenu.this.add.show(n);
                }
            }
        };
    }

    public static interface ArtikelDetailDisplay {
        public boolean show(Artikel var1);
    }

    class ArtikelMenuListener
    implements IMenuListener {
        ArtikelMenuListener() {
        }

        public void menuAboutToShow(IMenuManager manager) {
            ArtikelContextMenu.this.menu.removeAll();
            for (IAction ac : ArtikelContextMenu.this.actions) {
                if (ac == null) {
                    ArtikelContextMenu.this.menu.add((IContributionItem)new Separator());
                    continue;
                }
                ArtikelContextMenu.this.menu.add(ac);
            }
        }
    }
}

