/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.IUnlockable;
import ch.elexis.core.ui.locks.LockDeniedNoActionLockHandler;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.controls.InteractionLink;
import ch.elexis.data.Artikel;
import ch.elexis.data.Eigenleistung;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerrechnungsDisplay
extends Composite
implements IUnlockable {
    private Text billedLabel;
    private InteractionLink interactionLink;
    private Table table;
    private TableViewer viewer;
    private MenuManager contextMenuManager;
    private Konsultation actEncounter;
    private String defaultRGB;
    private IWorkbenchPage page;
    private final PersistentObjectDropTarget dropTarget;
    private IAction applyMedicationAction;
    private IAction chPriceAction;
    private IAction chCountAction;
    private IAction chTextAction;
    private IAction removeAction;
    private IAction removeAllAction;
    private static final String INDICATED_MEDICATION = Messages.VerrechnungsDisplay_indicatedMedication;
    private static final String APPLY_MEDICATION = Messages.VerrechnungsDisplay_applyMedication;
    private static final String CHPRICE = Messages.VerrechnungsDisplay_changePrice;
    private static final String CHCOUNT = Messages.VerrechnungsDisplay_changeNumber;
    private static final String REMOVE = Messages.VerrechnungsDisplay_removeElements;
    private static final String CHTEXT = Messages.VerrechnungsDisplay_changeText;
    private static final String REMOVEALL = Messages.VerrechnungsDisplay_removeAll;
    static Logger logger = LoggerFactory.getLogger(VerrechnungsDisplay.class);
    private final ElexisEventListener eeli_update = new ElexisUiEventListenerImpl(Konsultation.class, 4){

        @Override
        public void runInUi(ElexisEvent ev) {
            PersistentObject obj = ev.getObject();
            if (obj != null && obj.equals((Object)VerrechnungsDisplay.this.actEncounter)) {
                VerrechnungsDisplay.this.viewer.setInput((Object)VerrechnungsDisplay.this.actEncounter.getLeistungen());
            }
        }
    };
    private TableColumnLayout tableLayout;
    private ToolBarManager toolBarManager;
    private TableViewerColumn partDisposalColumn;

    public VerrechnungsDisplay(IWorkbenchPage p, Composite parent, int style) {
        super(parent, style);
        int columns_for_each_drug = 4;
        this.setLayout((Layout)new GridLayout(4, false));
        this.page = p;
        this.defaultRGB = UiDesk.createColor(new RGB(255, 255, 255));
        Label label = new Label((Composite)this, 0);
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        label.setFont(boldFont);
        label.setText(Messages.VerrechnungsDisplay_billing);
        this.billedLabel = new Text((Composite)this, 64);
        this.billedLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.interactionLink = new InteractionLink(this, 0);
        this.interactionLink.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.toolBarManager = new ToolBarManager(131072);
        Action newAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NEW.getImageDescriptor();
            }

            public void run() {
                try {
                    if (StringTool.isNothing((Object)"ch.elexis.LeistungenView")) {
                        SWTHelper.alert(Messages.VerrechnungsDisplay_error, "LeistungenView.ID");
                    }
                    VerrechnungsDisplay.this.page.showView("ch.elexis.LeistungenView");
                    CodeSelectorHandler.getInstance().setCodeSelectorTarget(VerrechnungsDisplay.this.dropTarget);
                }
                catch (Exception ex) {
                    ElexisStatus status = new ElexisStatus(4, "ch.elexis.core.ui", 0, String.valueOf(Messages.VerrechnungsDisplay_errorStartingCodeWindow) + ex.getMessage(), ex, 2);
                    StatusManager.getManager().handle((IStatus)status, 2);
                }
            }

            public boolean isEnabled() {
                return VerrechnungsDisplay.this.actEncounter != null && VerrechnungsDisplay.this.actEncounter.isBillable();
            }
        };
        newAction.setToolTipText(Messages.VerrechnungsDisplay_AddItem);
        this.toolBarManager.add((IAction)newAction);
        this.toolBarManager.add((IAction)new Action("", 2){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_NOBILLING.getImageDescriptor();
            }

            public String getText() {
                return Messages.VerrechnungsDisplay_no_invoice;
            }

            public void run() {
                VerrechnungsDisplay.this.actEncounter.setBillable(!VerrechnungsDisplay.this.actEncounter.isBillable());
                VerrechnungsDisplay.this.updateUi();
            }

            public boolean isChecked() {
                if (VerrechnungsDisplay.this.actEncounter != null) {
                    return !VerrechnungsDisplay.this.actEncounter.isBillable();
                }
                return false;
            }

            public boolean isEnabled() {
                return VerrechnungsDisplay.this.actEncounter != null && !this.isBilled(VerrechnungsDisplay.this.actEncounter);
            }

            private boolean isBilled(Konsultation encounter) {
                if (encounter != null) {
                    return encounter.getRechnung() != null;
                }
                return false;
            }
        });
        ToolBar toolBar = this.toolBarManager.createControl((Composite)this);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.makeActions();
        this.tableLayout = new TableColumnLayout();
        Composite tableComposite = new Composite((Composite)this, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        tableComposite.setLayout((Layout)this.tableLayout);
        this.viewer = new TableViewer(tableComposite, 68354);
        this.table = this.viewer.getTable();
        this.table.setMenu(this.createVerrMenu());
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.createColumns();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof Verrechnet) {
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)selection.getFirstElement()));
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && VerrechnungsDisplay.this.table.getSelectionIndices().length >= 1 && VerrechnungsDisplay.this.removeAction != null) {
                    VerrechnungsDisplay.this.removeAction.run();
                }
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int clickedIndex = -1;
                int width = 0;
                TableColumn[] columns = VerrechnungsDisplay.this.table.getColumns();
                int i = 0;
                while (i < columns.length) {
                    TableColumn tc = columns[i];
                    if (width < e.x && e.x < width + tc.getWidth()) {
                        clickedIndex = i;
                        break;
                    }
                    width += tc.getWidth();
                    ++i;
                }
                if (clickedIndex != -1) {
                    if (clickedIndex == 1) {
                        VerrechnungsDisplay.this.chCountAction.run();
                    } else if (clickedIndex == 4) {
                        VerrechnungsDisplay.this.chPriceAction.run();
                    } else if (clickedIndex == 5) {
                        VerrechnungsDisplay.this.removeAction.run();
                    }
                }
            }
        });
        this.dropTarget = new PersistentObjectDropTarget(Messages.VerrechnungsDisplay_doBill, (Control)this.table, new DropReceiver()){

            @Override
            protected Control getHighLightControl() {
                return VerrechnungsDisplay.this;
            }
        };
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{new ElexisUiEventListenerImpl(Verrechnet.class, 4){

            @Override
            public void runInUi(ElexisEvent ev) {
                PersistentObject object = ev.getObject();
                if (object != null) {
                    VerrechnungsDisplay.this.viewer.update((Object)object, null);
                }
            }
        }});
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_update});
    }

    private void createColumns() {
        String[] titles = new String[]{"", Messages.Display_Column_Number, Messages.Display_Column_Code, Messages.Display_Column_Designation, Messages.Display_Column_Price, ""};
        int[] nArray = new int[6];
        nArray[1] = 8;
        nArray[2] = 20;
        nArray[3] = 50;
        nArray[4] = 15;
        nArray[5] = 7;
        int[] weights = nArray;
        this.partDisposalColumn = this.createTableViewerColumn(titles[0], weights[0], 0, 16384);
        this.partDisposalColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                Verrechnet billed;
                if (element instanceof Verrechnet && VerrechnungsDisplay.this.isPartDisposal(billed = (Verrechnet)element)) {
                    return Images.IMG_BLOCKS_SMALL.getImage();
                }
                return super.getImage(element);
            }
        });
        TableViewerColumn col = this.createTableViewerColumn(titles[1], weights[1], 1, 16384);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Verrechnet) {
                    Verrechnet billed = (Verrechnet)element;
                    return Integer.toString(billed.getZahl());
                }
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[2], weights[2], 2, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Verrechnet) {
                    Verrechnet billed = (Verrechnet)element;
                    return VerrechnungsDisplay.this.getServiceCode(billed);
                }
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[3], weights[3], 3, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Verrechnet) {
                    Verrechnet billed = (Verrechnet)element;
                    return billed.getText();
                }
                return "";
            }

            public Color getBackground(Object element) {
                System.out.println("Getting bg of " + element);
                if (element instanceof Verrechnet) {
                    Verrechnet billed = (Verrechnet)element;
                    return VerrechnungsDisplay.this.getBackgroundColor(billed);
                }
                return null;
            }
        });
        col = this.createTableViewerColumn(titles[4], weights[4], 4, 131072);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Verrechnet) {
                    Verrechnet billed = (Verrechnet)element;
                    Money price = billed.getNettoPreis().multiply((double)billed.getZahl());
                    return price.getAmountAsString();
                }
                return "";
            }
        });
        col = this.createTableViewerColumn(titles[5], weights[5], 5, 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return "";
            }

            public Image getImage(Object element) {
                return Images.IMG_DELETE.getImage();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int weight, int colNumber, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(false);
        this.tableLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(weight));
        return viewerColumn;
    }

    private Color getBackgroundColor(Verrechnet billed) {
        IVerrechenbar billable = billed.getVerrechenbar();
        if (billable != null) {
            Color color = UiDesk.getColorFromRGB(this.defaultRGB);
            String codeName = billable.getCodeSystemName();
            if (codeName != null) {
                String rgbColor = CoreHub.globalCfg.get("billing/color/" + codeName, this.defaultRGB);
                color = UiDesk.getColorFromRGB(rgbColor);
            }
            return color;
        }
        return null;
    }

    public void clear() {
        this.actEncounter = null;
        this.viewer.setInput(Collections.emptyList());
        this.updateBilledLabel();
    }

    private void updateBilledLabel() {
        ArrayList<Artikel> gtins = new ArrayList<Artikel>();
        if (this.actEncounter != null) {
            Money sum = new Money(0);
            for (Verrechnet billed : this.actEncounter.getLeistungen()) {
                Money preis = billed.getNettoPreis().multiply((double)billed.getZahl());
                sum.addMoney(preis);
                IVerrechenbar verrechenbar = billed.getVerrechenbar();
                if (verrechenbar == null || !(verrechenbar instanceof Artikel)) continue;
                Artikel art = (Artikel)verrechenbar;
                gtins.add(art);
            }
            this.interactionLink.updateAtcs(gtins);
            this.billedLabel.setText(String.format("%s %s / %s %s", Messages.VerrechnungsDisplay_Amount, sum.getAmountAsString(), Messages.VerrechnungsDisplay_Time, this.actEncounter.getMinutes()));
        } else {
            this.billedLabel.setText("");
        }
        this.layout();
    }

    public void addPersistentObject(PersistentObject o) {
        Konsultation actKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
        if (actKons != null) {
            if (o instanceof Leistungsblock) {
                Leistungsblock block = (Leistungsblock)o;
                List elements = block.getElements();
                for (ICodeElement element : elements) {
                    if (!(element instanceof PersistentObject)) continue;
                    this.addPersistentObject((PersistentObject)element);
                }
                List diff = block.getDiffToReferences(elements);
                if (!diff.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    diff.forEach(r -> {
                        if (sb.length() > 0) {
                            sb.append("\n");
                        }
                        sb.append(r);
                    });
                    MessageDialog.openWarning((Shell)this.getShell(), (String)"Warnung", (String)("Warnung folgende Leistungen konnten im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.\n" + sb.toString()));
                }
            }
            if (o instanceof Prescription) {
                Prescription presc = (Prescription)o;
                o = presc.getArtikel();
            }
            if (o instanceof IVerrechenbar) {
                if (!CoreHub.acl.request(AccessControlDefaults.LSTG_VERRECHNEN)) {
                    SWTHelper.alert(Messages.VerrechnungsDisplay_missingRightsCaption, Messages.VerrechnungsDisplay_missingRightsBody);
                } else {
                    Result result = actKons.addLeistung((IVerrechenbar)o);
                    if (!result.isOK()) {
                        SWTHelper.alert(Messages.VerrechnungsDisplay_imvalidBilling, result.toString());
                    }
                    this.viewer.setInput((Object)actKons.getLeistungen());
                    this.updatePartDisposalColumn(actKons.getLeistungen());
                }
            } else if (o instanceof IDiagnose) {
                actKons.addDiagnose((IDiagnose)o);
            }
        }
    }

    private void updatePartDisposalColumn(List<Verrechnet> list) {
        boolean hasDisposal = false;
        for (Verrechnet billed : list) {
            if (!this.isPartDisposal(billed)) continue;
            hasDisposal = true;
            break;
        }
        if (hasDisposal) {
            this.partDisposalColumn.getColumn().setWidth(18);
        } else {
            this.partDisposalColumn.getColumn().setWidth(0);
        }
    }

    private boolean isPartDisposal(Verrechnet billed) {
        Artikel a;
        int abgabeEinheit;
        IVerrechenbar billable = billed.getVerrechenbar();
        return billable instanceof Artikel && (abgabeEinheit = (a = (Artikel)billable).getAbgabeEinheit()) > 0 && abgabeEinheit < Math.abs(a.getPackungsGroesse());
    }

    public void setEncounter(Konsultation encounter) {
        this.actEncounter = encounter;
        this.viewer.setInput((Object)encounter.getLeistungen());
        this.updatePartDisposalColumn(encounter.getLeistungen());
        this.updateBilledLabel();
        this.updateUi();
    }

    private void updateUi() {
        if (this.toolBarManager != null) {
            IContributionItem[] iContributionItemArray = this.toolBarManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem contribution = iContributionItemArray[n2];
                contribution.update();
                ++n2;
            }
            this.toolBarManager.update(true);
        }
        this.viewer.getTable().setEnabled(this.actEncounter != null && this.actEncounter.isBillable());
    }

    private String getServiceCode(Verrechnet verrechnet) {
        String ret = verrechnet.getCode();
        IVerrechenbar verrechenbar = verrechnet.getVerrechenbar();
        if (verrechenbar != null && (verrechenbar instanceof Eigenleistung || verrechenbar instanceof Artikel && "Eigenartikel".equals(((Artikel)verrechenbar).get("Typ"))) && verrechenbar.getId().equals(ret)) {
            ret = "";
        }
        return ret;
    }

    private Menu createVerrMenu() {
        this.contextMenuManager = new MenuManager();
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                if (selection.size() > 1) {
                    manager.add(VerrechnungsDisplay.this.removeAction);
                } else if (!selection.isEmpty()) {
                    final Verrechnet v = (Verrechnet)selection.getFirstElement();
                    IVerrechenbar verrechenbar = v.getVerrechenbar();
                    manager.add(VerrechnungsDisplay.this.chPriceAction);
                    manager.add(VerrechnungsDisplay.this.chCountAction);
                    IVerrechenbar vbar = v.getVerrechenbar();
                    List itemActions = vbar.getActions((Object)v);
                    if (itemActions != null && itemActions.size() > 0) {
                        manager.add((IContributionItem)new Separator());
                        for (IAction a : itemActions) {
                            if (a == null) continue;
                            manager.add(a);
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add(VerrechnungsDisplay.this.chTextAction);
                    manager.add(VerrechnungsDisplay.this.removeAction);
                    manager.add((IContributionItem)new Separator());
                    manager.add(VerrechnungsDisplay.this.removeAllAction);
                    if (verrechenbar instanceof Artikel) {
                        manager.add((IContributionItem)new Separator());
                        manager.add(VerrechnungsDisplay.this.applyMedicationAction);
                        manager.add((IAction)new Action(INDICATED_MEDICATION, 2){

                            public void run() {
                                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                                for (Object selected : selection.toList()) {
                                    if (!(selected instanceof Verrechnet)) continue;
                                    final Verrechnet billed = (Verrechnet)selected;
                                    AcquireLockUi.aquireAndRun((IPersistentObject)billed, new LockDeniedNoActionLockHandler(){

                                        @Override
                                        public void lockAcquired() {
                                            if (this.isIndicated(billed)) {
                                                billed.setDetail("indicated", "false");
                                            } else {
                                                billed.setDetail("indicated", "true");
                                            }
                                        }
                                    });
                                }
                            }

                            private boolean isIndicated(Verrechnet billed) {
                                String value = billed.getDetail("indicated");
                                return "true".equalsIgnoreCase(value);
                            }

                            public boolean isChecked() {
                                return this.isIndicated(v);
                            }
                        });
                    }
                }
            }
        });
        return this.contextMenuManager.createContextMenu((Control)this.table);
    }

    private void makeActions() {
        this.applyMedicationAction = new Action(APPLY_MEDICATION){

            public void run() {
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof Verrechnet)) continue;
                    final Verrechnet billed = (Verrechnet)selected;
                    AcquireLockUi.aquireAndRun((IPersistentObject)billed, new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            Prescription prescription;
                            billed.setDetail("vat_scale", Double.toString(0.0));
                            int packungsGroesse = ((Artikel)billed.getVerrechenbar()).getPackungsGroesse();
                            String proposal = packungsGroesse > 0 ? "1/" + packungsGroesse : "1";
                            VerrechnungsDisplay.this.changeQuantityDialog(proposal, billed);
                            String prescriptionId = billed.getDetail("prescriptionId");
                            if (prescriptionId instanceof String && (prescription = Prescription.load((String)prescriptionId)).getEntryType() == EntryType.SELF_DISPENSED) {
                                prescription.setApplied(Boolean.valueOf(true));
                            }
                        }
                    });
                }
            }

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_SYRINGE.getImageDescriptor();
            }
        };
        this.removeAction = new Action(REMOVE){

            public void run() {
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof Verrechnet)) continue;
                    final Verrechnet billed = (Verrechnet)selected;
                    AcquireLockUi.aquireAndRun((IPersistentObject)billed, new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            Result result = ((Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class)).removeLeistung(billed);
                            if (!result.isOK()) {
                                SWTHelper.alert(Messages.VerrechnungsDisplay_PositionCanootBeRemoved, result.toString());
                            }
                        }
                    });
                }
                VerrechnungsDisplay.this.setEncounter(VerrechnungsDisplay.this.actEncounter);
            }
        };
        this.removeAllAction = new Action(REMOVEALL){

            public void run() {
                if (!VerrechnungsDisplay.this.actEncounter.isEditable(true)) {
                    return;
                }
                List allBilled = VerrechnungsDisplay.this.actEncounter.getLeistungen();
                for (final Verrechnet billed : allBilled) {
                    AcquireLockUi.aquireAndRun((IPersistentObject)billed, new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            Result result = ((Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class)).removeLeistung(billed);
                            if (!result.isOK()) {
                                SWTHelper.alert(Messages.VerrechnungsDisplay_PositionCanootBeRemoved, result.toString());
                            }
                        }
                    });
                }
                VerrechnungsDisplay.this.setEncounter(VerrechnungsDisplay.this.actEncounter);
            }
        };
        this.chPriceAction = new Action(CHPRICE){

            public void run() {
                if (!VerrechnungsDisplay.this.actEncounter.isEditable(true)) {
                    return;
                }
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof Verrechnet)) continue;
                    final Verrechnet billed = (Verrechnet)selected;
                    AcquireLockUi.aquireAndRun((IPersistentObject)billed, new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            Money oldPrice = billed.getBruttoPreis();
                            String p = oldPrice.getAmountAsString();
                            InputDialog dlg = new InputDialog(UiDesk.getTopShell(), Messages.VerrechnungsDisplay_changePriceForService, Messages.VerrechnungsDisplay_enterNewPrice, p, null);
                            if (dlg.open() == 0) {
                                try {
                                    String val = dlg.getValue().trim();
                                    Money newPrice = new Money(oldPrice);
                                    if (val.endsWith("%") && val.length() > 1) {
                                        val = val.substring(0, val.length() - 1);
                                        double percent = Double.parseDouble(val);
                                        double factor = 1.0 + percent / 100.0;
                                        billed.setSecondaryScaleFactor(factor);
                                    } else {
                                        newPrice = new Money(val);
                                        billed.setTP((double)newPrice.getCents());
                                        billed.setSecondaryScaleFactor(1.0);
                                        billed.setDetail("changedPrice", "true");
                                    }
                                    VerrechnungsDisplay.this.viewer.update((Object)billed, null);
                                }
                                catch (ParseException ex) {
                                    SWTHelper.showError(Messages.VerrechnungsDisplay_badAmountCaption, Messages.VerrechnungsDisplay_badAmountBody);
                                }
                            }
                        }
                    });
                }
                VerrechnungsDisplay.this.updateBilledLabel();
            }
        };
        this.chCountAction = new Action(CHCOUNT){

            public void run() {
                if (!VerrechnungsDisplay.this.actEncounter.isEditable(true)) {
                    return;
                }
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof Verrechnet)) continue;
                    final Verrechnet billed = (Verrechnet)selected;
                    final String p = Integer.toString(billed.getZahl());
                    AcquireLockUi.aquireAndRun((IPersistentObject)billed, new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            VerrechnungsDisplay.this.changeQuantityDialog(p, billed);
                        }
                    });
                }
                VerrechnungsDisplay.this.updateBilledLabel();
            }
        };
        this.chTextAction = new Action(CHTEXT){

            public void run() {
                if (!VerrechnungsDisplay.this.actEncounter.isEditable(true)) {
                    return;
                }
                IStructuredSelection selection = VerrechnungsDisplay.this.viewer.getStructuredSelection();
                for (Object selected : selection.toList()) {
                    if (!(selected instanceof Verrechnet)) continue;
                    final Verrechnet billed = (Verrechnet)selected;
                    AcquireLockUi.aquireAndRun((IPersistentObject)billed, new LockDeniedNoActionLockHandler(){

                        @Override
                        public void lockAcquired() {
                            String oldText = billed.getText();
                            InputDialog dlg = new InputDialog(UiDesk.getTopShell(), Messages.VerrechnungsDisplay_changeTextCaption, Messages.VerrechnungsDisplay_changeTextBody, oldText, null);
                            if (dlg.open() == 0) {
                                String input = dlg.getValue();
                                if (input.matches("[0-9\\.,]+") && !SWTHelper.askYesNo(Messages.VerrechnungsDisplay_confirmChangeTextCaption, Messages.VerrechnungsDisplay_confirmChangeTextBody)) {
                                    return;
                                }
                                billed.setText(input);
                                VerrechnungsDisplay.this.viewer.update((Object)billed, null);
                            }
                        }
                    });
                }
            }
        };
    }

    private void changeQuantityDialog(String p, Verrechnet v) {
        InputDialog dlg = new InputDialog(UiDesk.getTopShell(), Messages.VerrechnungsDisplay_changeNumberCaption, Messages.VerrechnungsDisplay_changeNumberBody, p, null);
        if (dlg.open() == 0) {
            try {
                String val = dlg.getValue();
                if (!StringTool.isNothing((Object)val)) {
                    int changeAnzahl;
                    double secondaryScaleFactor = 1.0;
                    String text = v.getVerrechenbar().getText();
                    if (val.indexOf("/") > 0) {
                        changeAnzahl = 1;
                        String[] frac = val.split("/");
                        secondaryScaleFactor = Double.parseDouble(frac[0]) / Double.parseDouble(frac[1]);
                        text = String.valueOf(v.getText()) + " (" + val + Messages.VerrechnungsDisplay_Orininalpackungen;
                    } else if (val.indexOf(46) > 0) {
                        changeAnzahl = 1;
                        secondaryScaleFactor = Double.parseDouble(val);
                        text = String.valueOf(v.getText()) + " (" + Double.toString(secondaryScaleFactor) + ")";
                    } else {
                        changeAnzahl = Integer.parseInt(dlg.getValue());
                    }
                    IStatus ret = v.changeAnzahlValidated(changeAnzahl);
                    if (ret.isOK()) {
                        v.setSecondaryScaleFactor(secondaryScaleFactor);
                        v.setText(text);
                    } else {
                        SWTHelper.showError(Messages.VerrechnungsDisplay_error, ret.getMessage());
                    }
                }
                this.viewer.update((Object)v, null);
            }
            catch (NumberFormatException ne) {
                SWTHelper.showError(Messages.VerrechnungsDisplay_invalidEntryCaption, Messages.VerrechnungsDisplay_invalidEntryBody);
            }
        }
    }

    @Override
    public void setUnlocked(boolean unlocked) {
        this.setEnabled(unlocked);
        this.redraw();
    }

    public MenuManager getMenuManager() {
        return this.contextMenuManager;
    }

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void adaptMenus() {
        this.table.getMenu().setEnabled(CoreHub.acl.request(AccessControlDefaults.LSTG_VERRECHNEN));
    }

    private final class DropReceiver
    implements PersistentObjectDropTarget.IReceiver {
        private DropReceiver() {
        }

        @Override
        public void dropped(PersistentObject o, DropTargetEvent ev) {
            if (this.accept(o)) {
                VerrechnungsDisplay.this.addPersistentObject(o);
            }
        }

        @Override
        public boolean accept(PersistentObject o) {
            if (ElexisEventDispatcher.getSelectedPatient() != null) {
                if (o instanceof Artikel) {
                    return !((Artikel)o).isProduct();
                }
                if (o instanceof IVerrechenbar) {
                    return true;
                }
                if (o instanceof IDiagnose) {
                    return true;
                }
                if (o instanceof Leistungsblock) {
                    return true;
                }
                if (o instanceof Prescription) {
                    Prescription p = (Prescription)o;
                    return p.getArtikel() != null && !p.getArtikel().isProduct();
                }
            }
            return false;
        }
    }
}

