/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.AbstractDataLoaderJob;
import ch.elexis.core.ui.actions.BackgroundJob;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class PatHeuteView
extends ViewPart
implements IActivationListener,
ISaveablePart2,
BackgroundJob.BackgroundJobListener {
    public static final String ID = "ch.elexis.PatHeuteView";
    static final String LEISTUNG_HINZU = Messages.PatHeuteView_add;
    static final String STAT_LEEREN = Messages.PatHeuteView_empty;
    private IAction printAction;
    private IAction reloadAction;
    private IAction filterAction;
    private IAction statAction;
    CommonViewer cv;
    ViewerConfigurer vc;
    FormToolkit tk = UiDesk.getToolkit();
    Form form;
    Text tPat;
    Text tTime;
    Text tMoney;
    Text tTime2;
    Text tMoney2;
    TimeTool datVon;
    TimeTool datBis;
    boolean bOpen = true;
    boolean bClosed = true;
    private String accountSys;
    private Konsultation[] kons;
    private final KonsLoader kload;
    private int numPat;
    private double sumTime;
    private double sumAll;
    PersistentObjectDropTarget dropTarget;
    ListDisplay<IVerrechenbar> ldFilter;
    private final Query<Konsultation> qbe;
    Composite parent;
    private final ElexisEventListener eeli_kons = new ElexisUiEventListenerImpl(Konsultation.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            PatHeuteView.this.selection((Konsultation)ev.getObject());
        }
    };

    public PatHeuteView() {
        this.datVon = new TimeTool();
        this.datBis = new TimeTool();
        this.qbe = new Query(Konsultation.class);
        this.kload = new KonsLoader(this.qbe);
        this.kload.addListener(this);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.parent = parent;
        this.makeActions();
        this.ldFilter = new ListDisplay(parent, 0, new ListDisplay.LDListener(){

            @Override
            public String getLabel(Object o) {
                return ((IVerrechenbar)o).getCode();
            }

            @Override
            public void hyperlinkActivated(String l) {
                if (l.equals(LEISTUNG_HINZU)) {
                    try {
                        if (StringTool.isNothing((Object)"ch.elexis.LeistungenView")) {
                            SWTHelper.alert(Messages.PatHeuteView_error, "LeistungenView.ID");
                        }
                        PatHeuteView.this.getViewSite().getPage().showView("ch.elexis.LeistungenView");
                        CodeSelectorHandler.getInstance().setCodeSelectorTarget(PatHeuteView.this.dropTarget);
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                    }
                } else if (l.equals(STAT_LEEREN)) {
                    PatHeuteView.this.ldFilter.clear();
                }
            }
        });
        this.ldFilter.addHyperlinks(LEISTUNG_HINZU, STAT_LEEREN);
        this.ldFilter.setLayoutData(SWTHelper.getFillGridData(1, true, 1, false));
        ((GridData)this.ldFilter.getLayoutData()).heightHint = 0;
        this.dropTarget = new PersistentObjectDropTarget("Statfilter", (Control)this.ldFilter, new DropReceiver());
        Composite top = new Composite(parent, 2048);
        top.setLayout((Layout)new RowLayout());
        final DatePickerCombo dpc = new DatePickerCombo(top, 2048);
        dpc.setDate(this.datVon.getTime());
        dpc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatHeuteView.this.datVon.setTimeInMillis(dpc.getDate().getTime());
            }
        });
        final DatePickerCombo dpb = new DatePickerCombo(top, 2048);
        dpb.setDate(this.datBis.getTime());
        dpb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatHeuteView.this.datBis.setTimeInMillis(dpb.getDate().getTime());
            }
        });
        final Button bOpenKons = new Button(top, 32);
        bOpenKons.setText(Messages.PatHeuteView_open);
        bOpenKons.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatHeuteView.this.bOpen = bOpenKons.getSelection();
            }
        });
        final Button bClosedKons = new Button(top, 32);
        bClosedKons.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatHeuteView.this.bClosed = bClosedKons.getSelection();
            }
        });
        ComboViewer cAccountingSys = new ComboViewer(top, 8);
        cAccountingSys.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        cAccountingSys.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        String allCases = Messages.PatHeuteView_all;
        List<String> faelle = Arrays.asList(BillingSystem.getAbrechnungsSysteme());
        ArrayList<String> accountingSys = new ArrayList<String>();
        accountingSys.add(allCases);
        accountingSys.addAll(faelle);
        cAccountingSys.setInput(accountingSys);
        cAccountingSys.setSelection((ISelection)new StructuredSelection((Object)allCases));
        cAccountingSys.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PatHeuteView.this.accountSys = (String)selection.getFirstElement();
                if (PatHeuteView.this.kons != null) {
                    PatHeuteView.this.kload.schedule();
                }
            }
        });
        bClosedKons.setText(Messages.PatHeuteView_billed);
        bOpenKons.setSelection(this.bOpen);
        bClosedKons.setSelection(this.bClosed);
        this.cv = new CommonViewer();
        this.vc = new ViewerConfigurer(new DefaultContentProvider(this.cv, Patient.class){

            @Override
            public Object[] getElements(Object inputElement) {
                if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_STATS)) {
                    return new Konsultation[0];
                }
                if (PatHeuteView.this.kons == null) {
                    PatHeuteView.this.kons = new Konsultation[0];
                    PatHeuteView.this.kload.schedule();
                }
                return PatHeuteView.this.kons;
            }
        }, new DefaultLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof Konsultation) {
                    Fall fall = ((Konsultation)element).getFall();
                    if (fall == null) {
                        return String.valueOf(Messages.PatHeuteView_noCase) + ((Konsultation)element).getLabel();
                    }
                    Patient pat = fall.getPatient();
                    return pat.getLabel();
                }
                return super.getText(element);
            }
        }, null, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(1, 512, this.cv));
        this.cv.create(this.vc, parent, 2048, this.getViewSite());
        this.form = this.tk.createForm(parent);
        this.form.setText(Messages.PatHeuteView_all);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Composite bottom = this.form.getBody();
        bottom.setLayout((Layout)new GridLayout(2, false));
        this.tk.createLabel(bottom, Messages.PatHeuteView_consultations);
        this.tPat = this.tk.createText(bottom, "", 2048);
        this.tPat.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tPat.setEditable(false);
        this.tk.createLabel(bottom, Messages.PatHeuteView_accTime);
        this.tTime = this.tk.createText(bottom, "", 2048);
        this.tTime.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tTime.setEditable(false);
        this.tk.createLabel(bottom, Messages.PatHeuteView_accAmount);
        this.tMoney = this.tk.createText(bottom, "", 2048);
        this.tMoney.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tMoney.setEditable(false);
        Form fSel = this.tk.createForm(parent);
        fSel.setText(Messages.PatHeuteView_marked);
        fSel.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        Composite cSel = fSel.getBody();
        cSel.setLayout((Layout)new GridLayout(2, false));
        this.tk.createLabel(cSel, Messages.PatHeuteView_accTime);
        this.tTime2 = this.tk.createText(cSel, "", 2048);
        this.tTime2.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tk.createLabel(cSel, Messages.PatHeuteView_accAmount);
        this.tMoney2 = this.tk.createText(cSel, "", 2048);
        this.tMoney2.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tTime2.setEditable(false);
        this.tMoney2.setEditable(false);
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createMenu(this.printAction, this.reloadAction, this.statAction);
        menus.createToolbar(this.reloadAction, this.filterAction);
        this.cv.getConfigurer().getContentProvider().startListening();
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        this.kload.schedule();
        this.cv.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                Konsultation k = (Konsultation)obj;
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k);
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k.getFall());
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)k.getFall().getPatient());
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.Konsdetail");
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        });
    }

    public void dispose() {
        this.cv.getConfigurer().getContentProvider().stopListening();
        this.kload.removeListener(this);
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
    }

    public void setFocus() {
        this.cv.notify(CommonViewer.Message.update);
    }

    private void selection(Konsultation k) {
        if (k == null) {
            this.tTime2.setText("");
            this.tMoney2.setText("");
        } else {
            try {
                this.tTime2.setText(Integer.toString(k.getMinutes()));
                Money mon = new Money();
                for (Verrechnet ver : k.getLeistungen()) {
                    mon = mon.addMoney(ver.getNettoPreis().multiply((double)ver.getZahl()));
                }
                this.tMoney2.setText(mon.getAmountAsString());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_kons});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_kons});
        }
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    @Override
    public void jobFinished(BackgroundJob j) {
        if (j.isValid()) {
            this.kons = (Konsultation[])j.getData();
            if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_STATS)) {
                this.tPat.setText("Sie haben keine Rechte f\u00fcr diese View");
            } else {
                this.tPat.setText(Integer.toString(this.numPat));
                this.tTime.setText(Double.toString(this.sumTime));
                DecimalFormat df = new DecimalFormat("0.00");
                this.tMoney.setText(df.format(this.sumAll));
                if (this.kons.length >= 1) {
                    this.selection(this.kons[this.kons.length - 1]);
                }
                this.cv.notify(CommonViewer.Message.update);
            }
        } else {
            this.kons = new Konsultation[0];
        }
    }

    private void makeActions() {
        this.statAction = new Action(Messages.PatHeuteView_statisticsAction){
            {
                this.setToolTipText(Messages.PatHeuteView_statisticsToolTip);
            }

            public void run() {
                StatLoader loader = new StatLoader();
                loader.schedule();
            }
        };
        this.printAction = new Action(Messages.PatHeuteView_printList){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.PatHeuteView_printListToolTip);
            }

            public void run() {
                TerminListeDialog tld = new TerminListeDialog(PatHeuteView.this.getViewSite().getShell());
                tld.open();
            }
        };
        this.reloadAction = new Action(Messages.PatHeuteView_reloadAction){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
                this.setToolTipText(Messages.PatHeuteView_reloadToolTip);
            }

            public void run() {
                PatHeuteView.this.kons = null;
                PatHeuteView.this.kload.schedule();
            }
        };
        this.filterAction = new Action(Messages.PatHeuteView_filterAction, 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.PatHeuteView_filterToolTip);
            }

            public void run() {
                GridData gd = (GridData)PatHeuteView.this.ldFilter.getLayoutData();
                gd.heightHint = PatHeuteView.this.filterAction.isChecked() ? 50 : 0;
                PatHeuteView.this.parent.layout(true);
            }
        };
    }

    private final class DropReceiver
    implements PersistentObjectDropTarget.IReceiver {
        private DropReceiver() {
        }

        @Override
        public void dropped(PersistentObject o, DropTargetEvent ev) {
            if (o instanceof IVerrechenbar) {
                PatHeuteView.this.ldFilter.add((IVerrechenbar)o);
            }
        }

        @Override
        public boolean accept(PersistentObject o) {
            return o instanceof IVerrechenbar;
        }
    }

    class KonsLoader
    extends AbstractDataLoaderJob {
        IVerrechenbar[] lfiltered;
        Set<Konsultation> corruptKons;
        Set<Konsultation> missingCaseKons;

        KonsLoader(Query<Konsultation> qbe) {
            super(Messages.PatHeuteView_loadConsultations, qbe, new String[]{Messages.PatHeuteView_date});
            this.setPriority(30);
            this.setUser(true);
        }

        @Override
        public IStatus execute(IProgressMonitor monitor) {
            if (CoreHub.actUser == null) {
                return Status.CANCEL_STATUS;
            }
            this.corruptKons = new HashSet<Konsultation>();
            this.missingCaseKons = new HashSet<Konsultation>();
            monitor.beginTask(Messages.PatHeuteView_loadKons, 1000);
            this.qbe.clear();
            this.qbe.add("Datum", ">=", PatHeuteView.this.datVon.toString(9));
            this.qbe.add("Datum", "<=", PatHeuteView.this.datBis.toString(9));
            if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_GLOBAL)) {
                if (CoreHub.actMandant == null) {
                    monitor.done();
                    return Status.OK_STATUS;
                }
                this.qbe.add("MandantID", "=", CoreHub.actMandant.getId());
            }
            if (PatHeuteView.this.bOpen && !PatHeuteView.this.bClosed) {
                this.qbe.add("RechnungsID", "", null);
            }
            if (PatHeuteView.this.bClosed && !PatHeuteView.this.bOpen) {
                this.qbe.add("RechnungsID", "NOT", null);
            }
            if (!PatHeuteView.this.bClosed && !PatHeuteView.this.bOpen) {
                this.qbe.insertFalse();
            }
            this.qbe.orderBy(false, new String[]{"Datum", "Zeit"});
            this.qbe.addPostQueryFilter(new IFilter(){

                public boolean select(Object toTest) {
                    if (PatHeuteView.this.filterAction.isChecked()) {
                        Konsultation k = (Konsultation)toTest;
                        List<IVerrechenbar> lFilt = ((KonsLoader)KonsLoader.this).PatHeuteView.this.ldFilter.getAll();
                        for (Verrechnet v : k.getLeistungen()) {
                            if (!lFilt.contains(v.getVerrechenbar())) continue;
                            return true;
                        }
                        return false;
                    }
                    return true;
                }
            });
            ArrayList<Konsultation> list = this.qbe.execute();
            monitor.worked(100);
            PatHeuteView.this.numPat = 0;
            PatHeuteView.this.sumAll = 0.0;
            PatHeuteView.this.sumTime = 0.0;
            if (list == null) {
                this.result = new Konsultation[0];
            } else {
                if (PatHeuteView.this.accountSys != null && !PatHeuteView.this.accountSys.isEmpty() && !PatHeuteView.this.accountSys.equals(Messages.PatHeuteView_all)) {
                    ArrayList<Konsultation> konsRet = new ArrayList<Konsultation>();
                    for (Konsultation kons : list) {
                        if (!kons.getFall().getAbrechnungsSystem().equals(PatHeuteView.this.accountSys)) continue;
                        konsRet.add(kons);
                    }
                    list = konsRet;
                }
                Konsultation[] ret = new Konsultation[list.size()];
                if (PatHeuteView.this.filterAction.isChecked()) {
                    this.lfiltered = PatHeuteView.this.ldFilter.getAll().toArray(new IVerrechenbar[0]);
                    if (this.lfiltered.length == 0) {
                        this.lfiltered = null;
                    }
                } else {
                    this.lfiltered = null;
                }
                int i = 0;
                for (PersistentObject persistentObject : list) {
                    if (((Konsultation)persistentObject).getFall() == null) {
                        this.missingCaseKons.add((Konsultation)persistentObject);
                    }
                    try {
                        ret[i++] = (Konsultation)persistentObject;
                        if (this.lfiltered != null) {
                            List lstg = ((Konsultation)persistentObject).getLeistungen();
                            for (Verrechnet v : lstg) {
                                int num = v.getZahl();
                                Money preis = v.getEffPreis().multiply((double)num);
                                int j = 0;
                                while (j < this.lfiltered.length) {
                                    if (this.lfiltered[j].equals(v.getVerrechenbar())) {
                                        PatHeuteView patHeuteView = PatHeuteView.this;
                                        patHeuteView.sumAll = patHeuteView.sumAll + (double)preis.getCents();
                                        PatHeuteView patHeuteView2 = PatHeuteView.this;
                                        patHeuteView2.sumTime = patHeuteView2.sumTime + (double)v.getVerrechenbar().getMinutes();
                                    }
                                    ++j;
                                }
                            }
                        } else {
                            for (Verrechnet verr : ((Konsultation)persistentObject).getLeistungen()) {
                                PatHeuteView patHeuteView = PatHeuteView.this;
                                patHeuteView.sumAll = patHeuteView.sumAll + verr.getNettoPreis().multiply((double)verr.getZahl()).doubleValue();
                            }
                            PatHeuteView patHeuteView = PatHeuteView.this;
                            patHeuteView.sumTime = patHeuteView.sumTime + (double)((Konsultation)persistentObject).getMinutes();
                        }
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        monitor.done();
                        this.result = new Konsultation[0];
                        return Status.CANCEL_STATUS;
                    }
                    catch (NullPointerException np) {
                        this.corruptKons.add((Konsultation)persistentObject);
                    }
                }
                PatHeuteView.this.numPat = ret.length;
                this.result = ret;
                monitor.done();
            }
            StringBuilder sb = new StringBuilder();
            if (this.corruptKons.size() > 0) {
                sb.append("Folgende Konsultationen enthalten ung\u00fcltige Leistungen: \n");
                for (Konsultation k : this.corruptKons) {
                    sb.append(String.valueOf(k.getLabel()) + ", " + k.getFall().getPatient().getLabel());
                    sb.append("\n");
                }
                sb.append("\n");
            }
            if (this.missingCaseKons.size() > 0) {
                sb.append("Folgende Konsultationen sind keinem Fall zugewiesen: \n");
                for (Konsultation k : this.missingCaseKons) {
                    sb.append(k.getLabel());
                    sb.append("\n");
                }
            }
            if (sb.length() > 0) {
                SWTHelper.showError("Achtung", "Fehlerhafte Konsultation(en) vorhanden!\n" + sb.toString());
                log.log("The following consultations contain invalid values...\n" + sb.toString(), 2);
            }
            return Status.OK_STATUS;
        }

        @Override
        public int getSize() {
            return 100;
        }
    }

    private static class StatCounter
    implements Comparable<StatCounter> {
        IVerrechenbar v;
        Money sum;
        Money cost;
        int num;

        StatCounter(IVerrechenbar vv) {
            this.v = vv;
            this.sum = new Money();
            this.cost = new Money();
            this.num = 0;
        }

        void add(int num, Money price, Money cost) {
            Money totalPrice = price.multiply((double)num);
            Money totalCost = cost.multiply((double)num);
            this.num += num;
            this.sum.addMoney(totalPrice);
            this.cost.addMoney(totalCost);
        }

        @Override
        public int compareTo(StatCounter o) {
            int vgroup;
            IVerrechenbar iv;
            String v1 = null;
            String v2 = null;
            String vc1 = null;
            String vc2 = null;
            if (this.v != null) {
                v1 = this.v.getCodeSystemName();
                vc1 = this.v.getCode();
            }
            if ((iv = o.v) != null) {
                v2 = iv.getCodeSystemName();
                vc2 = iv.getCode();
            }
            if ((vgroup = StringTool.compareWithNull((String)v1, (String)v2)) != 0) {
                return vgroup;
            }
            int vCode = StringTool.compareWithNull((String)vc1, (String)vc2);
            if (vCode != 0) {
                return vCode;
            }
            return this.sum.getCents() - o.sum.getCents();
        }

        public Money getGewinn() {
            Money ret = new Money(this.sum);
            ret.subtractMoney(this.cost);
            return ret;
        }
    }

    class StatLoader
    extends Job {
        StatLoader() {
            super(Messages.PatHeuteView_calculateStats);
            this.setPriority(30);
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            HashMap<IVerrechenbar, StatCounter> counter = new HashMap<IVerrechenbar, StatCounter>();
            monitor.beginTask(Messages.PatHeuteView_calculateStats, PatHeuteView.this.kons.length + 20);
            System.out.println(String.valueOf(Messages.PatHeuteView_consElexis) + PatHeuteView.this.kons.length);
            int serviceCounter = 0;
            Konsultation[] konsultationArray = PatHeuteView.this.kons;
            int n = konsultationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Konsultation k = konsultationArray[n2];
                List list = k.getLeistungen();
                serviceCounter += list.size();
                for (Verrechnet v : list) {
                    StatCounter sc = (StatCounter)counter.get(v.getVerrechenbar());
                    if (sc == null) {
                        sc = new StatCounter(v.getVerrechenbar());
                        counter.put(v.getVerrechenbar(), sc);
                    }
                    sc.add(v.getZahl(), v.getNettoPreis(), v.getKosten());
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ++n2;
            }
            System.out.println(String.valueOf(Messages.PatHeuteView_servicesElexis) + serviceCounter);
            final LinkedList sums = new LinkedList(counter.values());
            Collections.sort(sums);
            monitor.worked(20);
            monitor.done();
            UiDesk.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FileDialog fd = new FileDialog(PatHeuteView.this.getSite().getShell(), 8192);
                    fd.setFilterExtensions(new String[]{"*.csv", "*.*"});
                    fd.setFilterNames(new String[]{"CSV", Messages.PatHeuteView_allFiles});
                    fd.setFileName("elexis-stat.csv");
                    String fname = fd.open();
                    if (fname != null) {
                        try {
                            FileWriter fw = new FileWriter(fname);
                            fw.write(Messages.PatHeuteView_csvHeader);
                            for (StatCounter st : sums) {
                                StringBuilder sb = new StringBuilder();
                                String code = "unknown";
                                String text = "unknown";
                                if (st.v != null) {
                                    code = st.v.getCode();
                                    text = st.v.getText();
                                }
                                text = text == null ? "" : text.replaceAll(";", ",");
                                if (st.v != null && st.v.getCodeSystemName() != null) {
                                    sb.append(st.v.getCodeSystemName());
                                } else {
                                    sb.append("Codesystem?");
                                }
                                sb.append("; ").append(code == null ? "" : code).append("; ").append(text).append(";").append(st.num).append(";").append(st.cost.getAmountAsString()).append(";").append(st.sum.getAmountAsString()).append(";").append(st.getGewinn().getAmountAsString()).append("\r\n");
                                fw.write(sb.toString());
                            }
                            fw.close();
                        }
                        catch (Exception ex) {
                            ExHandler.handle((Throwable)ex);
                            SWTHelper.showError(Messages.PatHeuteView_errorWriting, ex.getMessage());
                        }
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    class TerminListeDialog
    extends TitleAreaDialog
    implements ITextPlugin.ICallback {
        IVerrechenbar[] lfiltered;
        int[] numLeistung;
        Money[] perLeistung;
        private TextContainer text;

        public TerminListeDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            this.text = new TextContainer(this.getShell());
            ret.setLayout((Layout)new FillLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.text.getPlugin().createContainer(ret, this);
            this.text.getPlugin().showMenu(false);
            this.text.getPlugin().showToolbar(false);
            int add = 2;
            if (PatHeuteView.this.filterAction.isChecked()) {
                this.lfiltered = PatHeuteView.this.ldFilter.getAll().toArray(new IVerrechenbar[0]);
                this.numLeistung = new int[this.lfiltered.length];
                add += this.lfiltered.length;
                this.perLeistung = new Money[this.lfiltered.length];
                int i = 0;
                while (i < this.lfiltered.length) {
                    this.perLeistung[i] = new Money();
                    ++i;
                }
            }
            this.text.createFromTemplateName(null, "Abrechnungsliste", "Allg.", (Kontakt)CoreHub.actUser, Messages.PatHeuteView_billing);
            String[][] table = new String[PatHeuteView.this.kons.length + add][];
            table[0] = new String[2];
            table[0][0] = Messages.PatHeuteView_consultation;
            table[0][1] = Messages.PatHeuteView_amountBilled;
            Money total = new Money();
            int i = 0;
            while (i < PatHeuteView.this.kons.length) {
                table[i + 1] = new String[2];
                Konsultation k = PatHeuteView.this.kons[i];
                table[i + 1][0] = String.valueOf(k.getFall().getPatient().getLabel()) + "\n" + k.getLabel();
                StringBuilder sb = new StringBuilder();
                List lstg = k.getLeistungen();
                Money subsum = new Money();
                for (Verrechnet v : lstg) {
                    int num = v.getZahl();
                    Money preis = v.getEffPreis().multiply((double)num);
                    if (this.lfiltered != null) {
                        int j = 0;
                        while (j < this.lfiltered.length) {
                            if (this.lfiltered[j].equals(v.getVerrechenbar())) {
                                int n = j;
                                this.numLeistung[n] = this.numLeistung[n] + num;
                                this.perLeistung[j].addMoney(preis);
                            }
                            ++j;
                        }
                    }
                    subsum.addMoney(preis);
                    sb.append(num).append(" ").append(v.getLabel()).append(" ").append(preis.getAmountAsString()).append("\n");
                }
                sb.append(Messages.PatHeuteView_total).append(subsum.getAmountAsString());
                total.addMoney(subsum);
                table[i + 1][1] = sb.toString();
                ++i;
            }
            table[((PatHeuteView)PatHeuteView.this).kons.length + 1] = new String[2];
            table[((PatHeuteView)PatHeuteView.this).kons.length + 1][0] = Messages.PatHeuteView_sum;
            table[((PatHeuteView)PatHeuteView.this).kons.length + 1][1] = total.getAmountAsString();
            if (this.lfiltered != null) {
                i = 0;
                while (i < this.lfiltered.length) {
                    table[((PatHeuteView)PatHeuteView.this).kons.length + 2 + i] = new String[2];
                    table[((PatHeuteView)PatHeuteView.this).kons.length + 2 + i][0] = this.lfiltered[i].getCode();
                    StringBuilder sb = new StringBuilder();
                    sb.append(Messages.PatHeuteView_billedTotal).append(this.numLeistung[i]).append(Messages.PatHeuteView_times).append(this.perLeistung[i].getAmountAsString());
                    table[((PatHeuteView)PatHeuteView.this).kons.length + 2 + i][1] = sb.toString();
                    ++i;
                }
            }
            this.text.getPlugin().setFont("Helvetica", 0, 9.0f);
            this.text.getPlugin().insertTable("[Liste]", 1, table, new int[]{30, 70});
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.PatHeuteView_billingList);
            this.setTitle(Messages.PatHeuteView_printBillingList);
            this.setMessage(Messages.PatHeuteView_printBillingExpl);
            this.getShell().setSize(900, 700);
            SWTHelper.center(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getShell());
        }

        protected void okPressed() {
            super.okPressed();
        }

        @Override
        public void save() {
        }

        @Override
        public boolean saveAs() {
            return false;
        }
    }
}

