/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.text;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.util.IKonsMakro;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Leistungsblock;
import ch.rgw.tools.Result;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BlockMakro
implements IKonsMakro {
    @Override
    public String executeMakro(String makro) {
        Konsultation actKons = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
        List macros = Leistungsblock.findMacrosValidForCurrentMandator((String)makro);
        if (macros != null && macros.size() > 0 && actKons != null) {
            Leistungsblock lb = (Leistungsblock)macros.get(0);
            this.addBlock(actKons, lb);
            return "";
        }
        return null;
    }

    public void addBlock(Konsultation kons, Leistungsblock block) {
        List elements = block.getElements();
        for (ICodeElement ice : elements) {
            if (ice instanceof IVerrechenbar) {
                Result res = kons.addLeistung((IVerrechenbar)ice);
                if (res.isOK()) continue;
                MessageEvent.fireError((String)"Error", (String)res.toString());
                continue;
            }
            if (!(ice instanceof IDiagnose)) continue;
            kons.addDiagnose((IDiagnose)ice);
        }
        List diff = block.getDiffToReferences(elements);
        if (!diff.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            diff.forEach(r -> {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(r);
            });
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warnung", (String)("Warnung folgende Leistungen konnten im aktuellen Kontext (Fall, Konsultation, Gesetz) nicht verrechnet werden.\n" + sb.toString()));
        }
    }
}

