/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.admin.ACE;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.data.PersistentObject;

public abstract class LockedRestrictedAction<T extends PersistentObject>
extends RestrictedAction {
    private T object;

    public LockedRestrictedAction(ACE requiredACE, String text) {
        super(requiredACE, text);
        this.setEnabled(false);
    }

    @Override
    public void reflectRight() {
        this.setEnabled(false);
        boolean rights = CoreHub.acl.request(this.necessaryRight);
        if (!rights) {
            return;
        }
        this.object = this.getTargetedObject();
        if (this.object == null) {
            return;
        }
        this.setEnabled(CoreHub.getLocalLockService().isLocked(this.object));
    }

    @Override
    public void doRun() {
        if (CoreHub.getLocalLockService().isLocked(this.object) && CoreHub.acl.request(this.necessaryRight) && this.object != null) {
            this.doRun(this.object);
        }
    }

    public abstract T getTargetedObject();

    public abstract void doRun(T var1);
}

