/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.lock.ILocalLockService;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.LockStatusDialog;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class LockStatusDialogHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID = "ch.elexis.core.ui.locks.LockStatusDialog";
    private ImageDescriptor localIcon;
    private ImageDescriptor remoteIcon;
    private ImageDescriptor standaloneIcon;

    public LockStatusDialogHandler() {
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{new ElexisUiEventListenerImpl(ILocalLockService.class, 8){
            private ICommandService commandService;

            @Override
            public void runInUi(ElexisEvent ev) {
                if (this.commandService == null) {
                    this.commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                }
                this.commandService.refreshElements(LockStatusDialogHandler.COMMAND_ID, null);
            }
        }});
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        LockStatusDialog lockStatusDialog = new LockStatusDialog(Hub.getActiveShell());
        lockStatusDialog.open();
        return null;
    }

    private void prepareIcons() {
        this.localIcon = Images.IMG_LOCK_CLOSED_YELLOW.getURLImageDescriptor();
        this.remoteIcon = Images.IMG_LOCK_CLOSED_GREEN.getURLImageDescriptor();
        this.standaloneIcon = Images.IMG_LOCK_CLOSED_GREY.getURLImageDescriptor();
    }

    public void updateElement(UIElement element, Map parameters) {
        ILocalLockService.Status status;
        if (this.localIcon == null || this.remoteIcon == null || this.standaloneIcon == null) {
            this.prepareIcons();
        }
        if ((status = CoreHub.getLocalLockService().getStatus()) == ILocalLockService.Status.STANDALONE) {
            element.setIcon(this.standaloneIcon);
        } else if (status == ILocalLockService.Status.LOCAL) {
            element.setIcon(this.localIcon);
        } else if (status == ILocalLockService.Status.REMOTE) {
            element.setIcon(this.remoteIcon);
        }
    }
}

