/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.data.Fall;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;

public class SelectFallNoObligationDialog
extends TitleAreaDialog {
    private static Fall lastSelectedFall;
    private IVerrechenbar noOblCode;
    private Fall oblFall;
    private Fall fall;
    private ComboViewer noOblFallCombo;

    public SelectFallNoObligationDialog(Fall oblFall, IVerrechenbar code) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.oblFall = oblFall;
        this.noOblCode = code;
    }

    public void create() {
        super.create();
        this.setTitle("Auf diesen Fall k\u00f6nnen nur Pflichtleitungen verrechnet werden.");
        this.setMessage("Erstellen bzw. w\u00e4hlen Sie einen Fall f\u00fcr die Nicht-Pflichtleistung:\n" + this.noOblCode.getText());
        this.getShell().setText("Fall f\u00fcr Nicht-Pflichtleistungen");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite areaComposite = new Composite(composite, 0);
        areaComposite.setLayoutData((Object)new GridData(1808));
        areaComposite.setLayout((Layout)new FormLayout());
        Label lbl = new Label(areaComposite, 0);
        lbl.setText("Fall erstellen");
        ToolBarManager tbManager = new ToolBarManager(8388928);
        tbManager.add(GlobalActions.neuerFallAction);
        ToolBar toolbar = tbManager.createControl(areaComposite);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(30, 5);
        toolbar.setLayoutData((Object)fd);
        lbl = new Label(areaComposite, 0);
        lbl.setText("Fall ausw\u00e4hlen");
        this.noOblFallCombo = new ComboViewer(areaComposite);
        this.noOblFallCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.noOblFallCombo.setInput(this.getNoObligationFaelle());
        this.noOblFallCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Fall)element).getLabel();
            }
        });
        if (lastSelectedFall != null) {
            this.noOblFallCombo.setSelection((ISelection)new StructuredSelection((Object)lastSelectedFall));
        }
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{new UpdateFallComboListener(this.noOblFallCombo, Fall.class, 255)});
        fd = new FormData();
        fd.top = new FormAttachment((Control)toolbar, 5);
        fd.left = new FormAttachment(0, 5);
        lbl.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)toolbar, 5);
        fd.left = new FormAttachment(30, 5);
        fd.right = new FormAttachment(100, -5);
        this.noOblFallCombo.getControl().setLayoutData((Object)fd);
        return areaComposite;
    }

    protected List<Fall> getNoObligationFaelle() {
        Fall[] faelle;
        ArrayList<Fall> ret = new ArrayList<Fall>();
        Fall[] fallArray = faelle = this.oblFall.getPatient().getFaelle();
        int n = faelle.length;
        int n2 = 0;
        while (n2 < n) {
            Fall f = fallArray[n2];
            String gesetz = f.getConfiguredBillingSystemLaw().name();
            if (f.isOpen() && !gesetz.equalsIgnoreCase("KVG")) {
                ret.add(f);
            }
            ++n2;
        }
        return ret;
    }

    public void okPressed() {
        Object obj = ((IStructuredSelection)this.noOblFallCombo.getSelection()).getFirstElement();
        if (obj instanceof Fall) {
            lastSelectedFall = this.fall = (Fall)obj;
            super.okPressed();
        }
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.setErrorMessage("Kein Fall ausgew\u00e4hlt.");
        }
    }

    public Fall getFall() {
        return this.fall;
    }

    private class UpdateFallComboListener
    extends ElexisUiEventListenerImpl {
        ComboViewer viewer;

        UpdateFallComboListener(ComboViewer viewer, Class<?> clazz, int mode) {
            super(clazz, mode);
            this.viewer = viewer;
        }

        @Override
        public void runInUi(ElexisEvent ev) {
            if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
                this.viewer.setInput(SelectFallNoObligationDialog.this.getNoObligationFaelle());
                this.viewer.refresh();
            }
        }
    }
}

