/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IOrder;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.article.IArticle;
import ch.elexis.core.ui.actions.ScannerEvents;
import ch.elexis.core.ui.text.ElexisText;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import ch.elexis.data.Bestellung;
import ch.elexis.data.BestellungEntry;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Stock;
import ch.elexis.data.StockEntry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;

public class OrderImportDialog
extends TitleAreaDialog {
    private static final String ALLE_MARKIEREN = " Alle markieren ";
    private static final int DIFF_SPINNER_MIN = 1;
    private static final int DIFF_SPINNER_DEFAULT = 1;
    private List<OrderElement> orderElements;
    private Bestellung bestellung;
    private Spinner diffSpinner;
    private ElexisText eanText;
    private TableViewer viewer;
    private Color verifiedColor;
    private Font boldFont;

    public OrderImportDialog(Shell parentShell, IOrder order) {
        super(parentShell);
        this.bestellung = (Bestellung)order;
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.orderElements = new ArrayList<OrderElement>();
        List items = this.bestellung.getEntries();
        for (BestellungEntry item : items) {
            OrderElement orderElement;
            IStockEntry stockEntry;
            if (item.getState() == 3) continue;
            Stock stock = item.getStock();
            if (stock != null) {
                stockEntry = CoreHub.getStockService().findStockEntryForArticleInStock((IStock)stock, item.getArticle().storeToString());
                if (stockEntry == null) continue;
                orderElement = new OrderElement(item, stockEntry, item.getCount());
                this.orderElements.add(orderElement);
                continue;
            }
            stockEntry = CoreHub.getStockService().findPreferredStockEntryForArticle(item.getArticle().storeToString(), ElexisEventDispatcher.getSelectedMandator().getId());
            if (stockEntry != null) {
                orderElement = new OrderElement(item, stockEntry, item.getCount());
                this.orderElements.add(orderElement);
                continue;
            }
            TransientStockEntry transienStockEntry = new TransientStockEntry(item.getArticle());
            OrderElement orderElement2 = new OrderElement(item, transienStockEntry, item.getCount());
            this.orderElements.add(orderElement2);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainArea = new Composite(parent, 0);
        mainArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        mainArea.setLayout((Layout)new GridLayout());
        Composite scannerArea = new Composite(mainArea, 0);
        scannerArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        scannerArea.setLayout((Layout)new GridLayout());
        Group scannerGroup = new Group(scannerArea, 0);
        scannerGroup.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        scannerGroup.setLayout((Layout)new GridLayout(4, false));
        scannerGroup.setText("Einlesen mit Barcode-Scanner");
        this.diffSpinner = new Spinner((Composite)scannerGroup, 0);
        this.diffSpinner.setMinimum(1);
        this.diffSpinner.setSelection(1);
        Label eanLabel = new Label((Composite)scannerGroup, 0);
        eanLabel.setText("EAN:");
        this.eanText = new ElexisText((Composite)scannerGroup, 0);
        this.eanText.setLayoutData(SWTHelper.getFillGridData(1, true, 1, false));
        this.eanText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    OrderImportDialog.this.applyScanner();
                }
            }
        });
        Button button = new Button((Composite)scannerGroup, 8);
        button.setText("\u00dcbernehmen");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OrderImportDialog.this.applyScanner();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite tableArea = new Composite(mainArea, 0);
        tableArea.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        tableArea.setLayout((Layout)new GridLayout());
        this.viewer = new TableViewer(tableArea, 65536);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.verifiedColor = table.getDisplay().getSystemColor(6);
        this.boldFont = this.createBoldFont(table.getFont());
        TableViewerFocusCellManager mgr = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && (event.keyCode == 13 || event.character == ' ') || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)mgr, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.createViewerColumns();
        this.viewer.setContentProvider((IContentProvider)new ViewerContentProvider());
        this.viewer.setInput((Object)this);
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Artikel a1 = ((OrderElement)e1).getArticle();
                Artikel a2 = ((OrderElement)e2).getArticle();
                if (a1 != null && a2 != null) {
                    return a1.getName().compareTo(a2.getName());
                }
                return 0;
            }
        });
        Composite cButtons = new Composite(mainArea, 0);
        cButtons.setLayout((Layout)new GridLayout(2, false));
        final Button clickAllButton = new Button(cButtons, 8);
        clickAllButton.setText(ALLE_MARKIEREN);
        clickAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean bv = true;
                if (clickAllButton.getText().equals(OrderImportDialog.ALLE_MARKIEREN)) {
                    bv = true;
                    clickAllButton.setText("Alle demarkieren");
                } else {
                    bv = false;
                    clickAllButton.setText(OrderImportDialog.ALLE_MARKIEREN);
                }
                for (OrderElement oe : OrderImportDialog.this.orderElements) {
                    oe.setVerified(bv);
                }
                OrderImportDialog.this.viewer.refresh(true);
            }
        });
        Button importButton = new Button(cButtons, 8);
        GridData gd = new GridData(131072, 0x1000000, false, false);
        importButton.setLayoutData((Object)gd);
        importButton.setText("Lagerbest\u00e4nde anpassen");
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OrderImportDialog.this.doImport();
            }
        });
        cButtons.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        return mainArea;
    }

    private Font createBoldFont(Font baseFont) {
        FontData fd = baseFont.getFontData()[0];
        Font font = new Font(baseFont.getDevice(), fd.getName(), fd.getHeight(), fd.getStyle() | 1);
        return font;
    }

    private void createViewerColumns() {
        final CheckboxCellEditor checkboxCellEditor = new CheckboxCellEditor((Composite)this.viewer.getTable());
        final TextCellEditor textCellEditor = new TextCellEditor((Composite)this.viewer.getTable());
        TableViewerColumn column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText("OK");
        column.getColumn().setWidth(50);
        column.setLabelProvider((CellLabelProvider)new CheckboxLabelProvider());
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            public boolean canEdit(Object element) {
                return true;
            }

            public CellEditor getCellEditor(Object element) {
                return checkboxCellEditor;
            }

            public Object getValue(Object element) {
                if (element instanceof OrderElement) {
                    OrderElement orderElement = (OrderElement)element;
                    return new Boolean(orderElement.isVerified());
                }
                return null;
            }

            public void setValue(Object element, Object value) {
                if (element instanceof OrderElement) {
                    OrderElement orderElement = (OrderElement)element;
                    if (value instanceof Boolean) {
                        Boolean bValue = (Boolean)value;
                        orderElement.setVerified(bValue);
                    }
                    OrderImportDialog.this.viewer.update((Object)orderElement, null);
                }
            }
        });
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText("Geliefert");
        column.getColumn().setWidth(60);
        column.setLabelProvider((CellLabelProvider)new AmountLabelProvider());
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            public boolean canEdit(Object element) {
                return true;
            }

            public CellEditor getCellEditor(Object element) {
                return textCellEditor;
            }

            public Object getValue(Object element) {
                if (element instanceof OrderElement) {
                    OrderElement orderElement = (OrderElement)element;
                    return orderElement.getAmountAsString();
                }
                return null;
            }

            public void setValue(Object element, Object value) {
                if (element instanceof OrderElement) {
                    OrderElement orderElement = (OrderElement)element;
                    if (value instanceof String) {
                        String text = (String)value;
                        try {
                            int amount = Integer.parseInt(text);
                            orderElement.setAmount(amount);
                            orderElement.setVerified(true);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    OrderImportDialog.this.viewer.update((Object)orderElement, null);
                }
            }
        });
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText("Lager");
        column.getColumn().setWidth(60);
        column.setLabelProvider((CellLabelProvider)new StockLabelProvider());
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText("Pharmacode");
        column.getColumn().setWidth(80);
        column.setLabelProvider((CellLabelProvider)new PharamcodeLabelProvider());
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText("EAN");
        column.getColumn().setWidth(110);
        column.setLabelProvider((CellLabelProvider)new EANLabelProvider());
        column = new TableViewerColumn(this.viewer, 16384);
        column.getColumn().setText("Beschreibung");
        column.getColumn().setWidth(300);
        column.setLabelProvider((CellLabelProvider)new DescriptionLabelProvider());
    }

    public void create() {
        super.create();
        if (this.bestellung != null) {
            this.setTitle("Bestellung " + this.bestellung.getLabel() + " im Lager einbuchen");
        } else {
            this.setTitle("Bestellung im Lager einbuchen");
        }
        this.setMessage("Bitte \u00fcberpr\u00fcfen Sie alle bestellten Artikel. \u00dcberpr\u00fcfte Artikel werden gr\u00fcn angezeigt. Bei der Anpassung der Lagerbest\u00e4nde werden nur jene Artikel ber\u00fccksichtigt, bei denen unter \"OK\" ein Haken gesetzt ist.");
        this.getShell().setText("Bestellung im Lager einbuchen");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Schliessen", false);
    }

    protected void okPressed() {
        super.okPressed();
    }

    private void applyScanner() {
        int diff = this.diffSpinner.getSelection();
        String ean = this.eanText.getText().trim();
        ean = ean.replaceAll(new Character('\r').toString(), "");
        ean = ean.replaceAll(new Character('\n').toString(), "");
        ean = ean.replaceAll(new Character('\u0000').toString(), "");
        this.eanText.setText("");
        this.diffSpinner.setSelection(1);
        OrderElement orderElement = this.findOrderElementByEAN(ean);
        if (orderElement != null) {
            int newAmount = orderElement.getAmount() + diff;
            this.updateOrderElement(orderElement, newAmount);
        } else {
            ScannerEvents.beep();
            SWTHelper.alert("Artikel nicht bestellt", "Dieser Artikel wurde nicht bestellt. Der Bestand kann nicht automatisch angepasst werden.");
        }
    }

    private OrderElement findOrderElementByEAN(String ean) {
        if (ean == null) {
            return null;
        }
        for (OrderElement orderElement : this.orderElements) {
            if (!orderElement.getArticle().getEAN().equals(ean)) continue;
            return orderElement;
        }
        return null;
    }

    private void updateOrderElement(OrderElement orderElement, int newAmount) {
        orderElement.setAmount(newAmount);
        orderElement.setVerified(true);
        this.viewer.update((Object)orderElement, null);
    }

    public void doImport() {
        try {
            for (OrderElement orderElement : this.orderElements) {
                LockResponse lockResponse;
                if (!orderElement.isVerified()) continue;
                IStockEntry stockEntry = orderElement.getStockEntry();
                if (stockEntry instanceof TransientStockEntry) {
                    stockEntry = ((TransientStockEntry)stockEntry).create(orderElement);
                }
                if ((lockResponse = CoreHub.getLocalLockService().acquireLockBlocking((IPersistentObject)((StockEntry)stockEntry), 1, (IProgressMonitor)new NullProgressMonitor())).isOk()) {
                    int diff = orderElement.getAmount();
                    int oldAmount = stockEntry.getCurrentStock();
                    int newAmount = oldAmount + diff;
                    stockEntry.setCurrentStock(newAmount);
                    orderElement.setAmount(0);
                    orderElement.setVerified(false);
                    if (diff > 0) {
                        if (orderElement.getOrderState() == 2) {
                            orderElement.setOrderState(3);
                        } else if (diff >= orderElement.getOrderAmount()) {
                            orderElement.setOrderState(3);
                        } else if (diff < orderElement.getOrderAmount()) {
                            orderElement.setOrderState(2);
                        }
                    }
                    CoreHub.getLocalLockService().releaseLock(lockResponse.getLockInfo());
                    continue;
                }
                throw new IllegalStateException("Could not acquire lock for stockEntry [" + stockEntry.getArticle().getLabel() + "]");
            }
        }
        catch (Exception ex) {
            SWTHelper.showError("Fehler bei Anpassung der Best\u00e4nde", "Best\u00e4nde konnten teilweise nicht korrekt angepasst werden: " + ex.getMessage());
        }
        this.viewer.refresh();
    }

    private class AmountLabelProvider
    extends BaseLabelProvider {
        private AmountLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                text = orderElement.getAmountAsString();
            }
            return text;
        }
    }

    private class BaseLabelProvider
    extends ColumnLabelProvider {
        private BaseLabelProvider() {
        }

        public Color getForeground(Object element) {
            OrderElement orderElement;
            Color color = null;
            if (element instanceof OrderElement && (orderElement = (OrderElement)element).isVerified()) {
                color = OrderImportDialog.this.verifiedColor;
            }
            return color;
        }

        public Font getFont(Object element) {
            OrderElement orderElement;
            Font font = null;
            if (element instanceof OrderElement && (orderElement = (OrderElement)element).isVerified() && orderElement.getAmount() > 0) {
                font = OrderImportDialog.this.boldFont;
            }
            return font;
        }
    }

    private class CheckboxLabelProvider
    extends BaseLabelProvider {
        private CheckboxLabelProvider() {
        }

        public String getText(Object element) {
            OrderElement orderElement;
            String text = "";
            if (element instanceof OrderElement && (orderElement = (OrderElement)element).isVerified()) {
                text = "X";
            }
            return text;
        }
    }

    private class DescriptionLabelProvider
    extends BaseLabelProvider {
        private DescriptionLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                text = orderElement.getArticle().getName();
            }
            return text;
        }
    }

    private class EANLabelProvider
    extends BaseLabelProvider {
        private EANLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                text = orderElement.getArticle().getEAN();
            }
            return text;
        }
    }

    private class OrderElement {
        private boolean verified = false;
        private final BestellungEntry orderEntry;
        private final IStockEntry stockEntry;
        private int amount;

        OrderElement(BestellungEntry orderEntry, IStockEntry stockEntry, int amount) {
            this.orderEntry = orderEntry;
            this.stockEntry = stockEntry;
            this.amount = amount;
        }

        int getAmount() {
            return this.amount;
        }

        int getOrderAmount() {
            return this.orderEntry.getCount();
        }

        void setOrderState(int state) {
            this.orderEntry.setState(state);
        }

        int getOrderState() {
            return this.orderEntry.getState();
        }

        void setAmount(int amount) {
            this.amount = amount;
        }

        public Artikel getArticle() {
            return (Artikel)this.stockEntry.getArticle();
        }

        String getAmountAsString() {
            return new Integer(this.amount).toString();
        }

        public IStockEntry getStockEntry() {
            return this.stockEntry;
        }

        boolean isVerified() {
            return this.verified;
        }

        void setVerified(boolean verified) {
            this.verified = verified;
        }
    }

    private class PharamcodeLabelProvider
    extends BaseLabelProvider {
        private PharamcodeLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                text = orderElement.getArticle().getPharmaCode();
            }
            return text;
        }
    }

    private class StockLabelProvider
    extends BaseLabelProvider {
        private StockLabelProvider() {
        }

        public String getText(Object element) {
            String text = "";
            if (element instanceof OrderElement) {
                OrderElement orderElement = (OrderElement)element;
                IStockEntry stockEntry = orderElement.getStockEntry();
                if (stockEntry instanceof TransientStockEntry) {
                    if (((TransientStockEntry)stockEntry).isCreated()) {
                        IStockEntry created = ((TransientStockEntry)stockEntry).getCreated();
                        text = new Integer(created.getCurrentStock()).toString();
                    } else {
                        text = "bisher kein Lagerartikel";
                    }
                } else {
                    text = new Integer(stockEntry.getCurrentStock()).toString();
                }
            }
            return text;
        }
    }

    private class TransientStockEntry
    implements IStockEntry {
        private Artikel article;
        private IStockEntry created = null;

        public TransientStockEntry(Artikel article) {
            this.article = article;
        }

        public IStockEntry create(OrderElement orderElement) {
            Stock stock = Stock.load((String)"STD");
            this.created = CoreHub.getStockService().storeArticleInStock((IStock)stock, this.article.storeToString());
            this.created.setMinimumStock(0);
            this.created.setMaximumStock(0);
            return this.created;
        }

        public boolean isCreated() {
            return this.created != null;
        }

        public IStockEntry getCreated() {
            return this.created;
        }

        public IArticle getArticle() {
            return this.article;
        }

        public int getMinimumStock() {
            return 0;
        }

        public void setMinimumStock(int minStock) {
        }

        public int getCurrentStock() {
            return 0;
        }

        public void setCurrentStock(int currentStock) {
        }

        public int getMaximumStock() {
            return 0;
        }

        public void setMaximumStock(int maxStock) {
        }

        public int getFractionUnits() {
            return 0;
        }

        public void setFractionUnits(int rest) {
        }

        public Object getProvider() {
            Kontakt defProvider;
            String providerId = CoreHub.globalCfg.get("inventory/defaultArticleProvider", null);
            if (providerId != null && (defProvider = Kontakt.load((String)providerId)).exists()) {
                return defProvider;
            }
            return null;
        }

        public void setProvider(Object provider) {
        }

        public IStock getStock() {
            return Stock.load((String)"STD");
        }
    }

    private class ViewerContentProvider
    implements IStructuredContentProvider {
        private ViewerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return OrderImportDialog.this.orderElements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

