/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.data.UiDBImage;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.DBImage;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ImageChooser
extends AbstractElementListSelectionDialog {
    private Object[] fElements;
    private Hyperlink hl;
    private Text tTitle;
    private static String NOFILESELECTED = Messages.ImageChooser_PleaseChooseFile;
    private Button bDB;
    private Button bFile;
    private UiDBImage result;

    public UiDBImage getSelection() {
        return this.result;
    }

    public ImageChooser(Shell shell) {
        super(shell, (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof UiDBImage) {
                    return ((UiDBImage)element).getImage();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof DBImage) {
                    return ((DBImage)element).getName();
                }
                return "?";
            }
        });
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
    }

    protected void computeResult() {
        if (this.bDB.getSelection()) {
            this.setResult(Arrays.asList(this.getSelectedElements()));
            Object[] sel = this.getResult();
            this.result = sel != null && sel.length > 0 ? new UiDBImage((DBImage)sel[0]) : null;
        }
    }

    private Menu createMenu(Control parent) {
        Menu ret = new Menu(parent);
        MenuItem item = new MenuItem(ret, 0);
        item.setText(Messages.ImageChooser_delete);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] oo = ImageChooser.this.getSelectedElements();
                if (oo != null && oo.length > 0 && SWTHelper.askYesNo(Messages.ImageChooser_reallyDeleteHeading, Messages.ImageChooser_reallyDeleteText)) {
                    Object[] objectArray = oo;
                    int n = oo.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        ((DBImage)o).delete();
                        ++n2;
                    }
                }
            }
        });
        return ret;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = (Composite)super.createDialogArea(parent);
        this.bDB = new Button(ret, 16);
        this.bDB.setText(Messages.ImageChooser_chooseImagefromDB);
        this.createMessageArea(ret);
        this.createFilterText(ret);
        FilteredList list = this.createFilteredList(ret);
        list.setMenu(this.createMenu((Control)list));
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageChooser.this.bFile.setSelection(false);
                ImageChooser.this.bDB.setSelection(true);
            }
        });
        new Label(ret, 258).setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bFile = new Button(ret, 16);
        this.bFile.setText(Messages.ImageChooser_importImage);
        Composite cBottom = new Composite(ret, 2048);
        cBottom.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        cBottom.setLayout((Layout)new GridLayout(2, false));
        new Label(cBottom, 0).setText(Messages.ImageChooser_imageFile);
        new Label(cBottom, 0).setText(Messages.ImageChooser_imageTitle);
        this.hl = new Hyperlink(cBottom, 0);
        this.tTitle = new Text(cBottom, 2048);
        this.hl.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ImageChooser.this.bFile.setSelection(true);
                ImageChooser.this.bDB.setSelection(false);
                FileDialog fd = new FileDialog(ImageChooser.this.getShell(), 4096);
                fd.setFilterExtensions(new String[]{"*.png", "*.gif", "*.jpg", "*.*"});
                fd.setFilterNames(new String[]{"Portable Network Graphics", "Grafics Interchange Format", "JPEG", Messages.ImageChooser_allFilesDesc});
                String filename = fd.open();
                if (filename != null) {
                    ImageChooser.this.hl.setText(filename);
                    ImageChooser.this.getOkButton().setEnabled(true);
                }
            }
        });
        this.hl.setText(NOFILESELECTED);
        this.hl.setForeground(UiDesk.getColor("blau"));
        this.hl.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tTitle.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.tTitle.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ImageChooser.this.bFile.setSelection(true);
                ImageChooser.this.bDB.setSelection(false);
            }
        });
        this.bDB.setSelection(true);
        Query qbe = new Query(DBImage.class);
        List imgs = qbe.execute();
        this.fElements = imgs != null ? imgs.toArray() : new Object[0];
        this.setListElements(this.fElements);
        this.setSelection(this.getInitialElementSelections().toArray());
        return ret;
    }

    public void okPressed() {
        String fname;
        if (this.bFile.getSelection() && !(fname = this.hl.getText()).equals(NOFILESELECTED)) {
            try {
                File file = new File(fname);
                this.result = new UiDBImage("ch.elexis.images", String.valueOf(this.tTitle.getText()) + ":" + file.getName(), new FileInputStream(file));
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }
        super.okPressed();
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.ImageChooser_choseFileFromDBHeading);
        this.setMessage(Messages.ImageChooser_choseFileFromDBText);
        this.setTitle(Messages.ImageChooser_imageSelection);
    }
}

