/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.PersistentObjectFactory;
import ch.elexis.data.Query;
import ch.rgw.tools.ExHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.internal.WorkbenchMessages;

public class DiagnoseSelektor
extends FilteredItemsSelectionDialog {
    private ArrayList<IDiagnose> diagnoses = new ArrayList();

    public DiagnoseSelektor(Shell shell) {
        super(shell);
        this.setTitle(Messages.DiagnoseSelektorDialog_Title);
        List list = Extensions.getExtensions((String)"ch.elexis.core.ui.Diagnosecode");
        this.diagnoses.add(new NoDiagnose());
        if (list != null) {
            for (IConfigurationElement ic : list) {
                try {
                    PersistentObjectFactory po = (PersistentObjectFactory)ic.createExecutableExtension("ElementFactory");
                    CodeSelectorFactory codeSelectorFactory = (CodeSelectorFactory)ic.createExecutableExtension("CodeSelectorFactory");
                    if (!codeSelectorFactory.getCodeSystemName().equalsIgnoreCase("TI-Code")) {
                        if (!IDiagnose.class.isAssignableFrom(codeSelectorFactory.getElementClass())) continue;
                        Query qd = new Query(codeSelectorFactory.getElementClass());
                        this.diagnoses.addAll(qd.execute());
                        continue;
                    }
                    CommonViewer cv = new CommonViewer();
                    ViewerConfigurer vc = codeSelectorFactory.createViewerConfigurer(new CommonViewer());
                    cv.create(vc, (Composite)shell, 0, (Object)this);
                    ITreeContentProvider tcp = (ITreeContentProvider)vc.getContentProvider();
                    Object[] roots = tcp.getElements(null);
                    this.addDiagnoses(tcp, roots);
                    cv.dispose();
                }
                catch (CoreException ex) {
                    ExHandler.handle((Throwable)ex);
                }
            }
        }
        this.setListLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return ((IDiagnose)element).getLabel();
            }
        });
        this.setDetailsLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return "";
                }
                return String.valueOf(((IDiagnose)element).getCodeSystemName()) + " " + ((IDiagnose)element).getLabel();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        String oldListLabel = WorkbenchMessages.FilteredItemsSelectionDialog_listLabel;
        this.setMessage(Messages.DiagnoseSelektorDialog_Message);
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = "";
        Control ret = super.createDialogArea(parent);
        WorkbenchMessages.FilteredItemsSelectionDialog_listLabel = oldListLabel;
        return ret;
    }

    private void addDiagnoses(ITreeContentProvider tcp, Object[] roots) {
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (tcp.hasChildren(object)) {
                this.addDiagnoses(tcp, tcp.getChildren(object));
            } else {
                this.diagnoses.add((IDiagnose)object);
            }
            ++n2;
        }
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        return new DialogSettings("diagnoseselektor");
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public boolean isConsistentItem(Object item) {
                return true;
            }

            public boolean matchItem(Object item) {
                IDiagnose diag = (IDiagnose)item;
                return this.matches(diag.getLabel());
            }
        };
    }

    protected Comparator getItemsComparator() {
        return new Comparator<IDiagnose>(){

            @Override
            public int compare(IDiagnose o1, IDiagnose o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (IDiagnose diagnose : this.diagnoses) {
            if (progressMonitor.isCanceled()) {
                return;
            }
            contentProvider.add((Object)diagnose, itemsFilter);
        }
    }

    public String getElementName(Object item) {
        IDiagnose diag = (IDiagnose)item;
        return diag.getLabel();
    }

    private class NoDiagnose
    extends PersistentObject
    implements IDiagnose {
        private NoDiagnose() {
        }

        public String getCodeSystemName() {
            return "";
        }

        public String getCodeSystemCode() {
            return "";
        }

        public String getId() {
            return "";
        }

        public String getCode() {
            return "";
        }

        public String getText() {
            return " keine ";
        }

        public String getLabel() {
            return this.getText();
        }

        protected String getTableName() {
            return "";
        }

        public List<Object> getActions(Object kontext) {
            return null;
        }
    }
}

