/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.perferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.findings.templates.model.FindingsTemplates;
import ch.elexis.core.findings.templates.ui.composite.FindingsComposite;
import ch.elexis.core.findings.templates.ui.composite.FindingsDetailComposite;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import java.util.Optional;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class FindingsTemplateSettings
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private FindingsComposite findingsComposite;

    public FindingsTemplateSettings() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new SettingsPreferenceStore(CoreHub.userCfg));
    }

    public void init(IWorkbench workbench) {
    }

    protected void adjustGridLayout() {
    }

    protected void createFieldEditors() {
        FindingsTemplates model = FindingsServiceHolder.findingsTemplateService.getFindingsTemplates("Standard Vorlagen");
        this.findingsComposite = new FindingsComposite(this.getFieldEditorParent(), model);
        FindingsDetailComposite findingsDetailComposite = new FindingsDetailComposite(this.getFieldEditorParent(), model, false);
        this.findingsComposite.setFindingsDetailComposite(findingsDetailComposite);
        this.findingsComposite.createContents();
        findingsDetailComposite.createContents();
        this.findingsComposite.selectFirstTreeElement();
    }

    public boolean performOk() {
        Optional<FindingsTemplates> model = this.findingsComposite.getModel();
        FindingsServiceHolder.findingsTemplateService.saveFindingsTemplates(model);
        if (model.isPresent()) {
            this.findingsComposite.setModel(model.get(), false);
        }
        return true;
    }
}

