/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.templates.ui.dlg;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.templates.ui.util.FindingsServiceHolder;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CodeCreateDialog
extends TitleAreaDialog {
    private Text txtDisplay;
    private Text txtCode;

    public CodeCreateDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Neuen Code anlegen");
        this.setTitle("Codesystem: " + CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblCode = new Label(composite, 0);
        lblCode.setText("Code");
        this.txtCode = new Text(composite, 2048);
        this.txtCode.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblDisplay = new Label(composite, 0);
        lblDisplay.setText("Display");
        this.txtDisplay = new Text(composite, 2048);
        this.txtDisplay.setLayoutData((Object)new GridData(4, 4, true, false));
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        final String code = this.txtCode.getText();
        final String display = this.txtDisplay.getText();
        if (StringUtils.isEmpty((CharSequence)code) || StringUtils.isEmpty((CharSequence)display)) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Bitte korriegen Sie Ihre Eingaben.");
        } else {
            FindingsServiceHolder.codingService.addLocalCoding(new ICoding(){

                public String getSystem() {
                    return CodingSystem.ELEXIS_LOCAL_CODESYSTEM.getSystem();
                }

                public String getDisplay() {
                    return display;
                }

                public String getCode() {
                    return code;
                }
            });
            super.okPressed();
        }
    }
}

