/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.eigenartikel;

import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.model.eigenartikel.EigenartikelTyp;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Eigenartikel
extends Artikel {
    private static IOptifier OPTIFIER;
    public static final String TYPNAME = "Eigenartikel";

    public Eigenartikel(String articleName, String productName) {
        this.create(null);
        this.set(new String[]{"Name", "Eigenname", "Typ"}, new String[]{articleName, productName, TYPNAME});
    }

    protected String getConstraint() {
        return "Typ" + "=" + JdbcLink.wrap((String)TYPNAME);
    }

    protected void setConstraint() {
        this.set("Typ", TYPNAME);
    }

    public String getCodeSystemName() {
        return TYPNAME;
    }

    public String getCodeSystemCode() {
        if (this.getTyp() == EigenartikelTyp.COMPLEMENTARY || this.getTyp() == EigenartikelTyp.COMPLEMENTARY_REDUCED) {
            return "590";
        }
        if (this.getTyp() == EigenartikelTyp.ADDITIVE) {
            return "406";
        }
        return super.getCodeSystemCode();
    }

    public String getLabel() {
        String name = this.get("Name");
        if (!this.isProduct()) {
            name = String.valueOf(name) + " " + this.getPackageSizeLabel();
        }
        return name;
    }

    public String getCode() {
        String ret = this.get("SubID");
        if (ret == null || ret.isEmpty()) {
            ret = this.getId();
        }
        return ret;
    }

    public String getGroup() {
        return Eigenartikel.checkNull((Object)this.get("Codeclass"));
    }

    public static Eigenartikel load(String id) {
        return new Eigenartikel(id);
    }

    protected Eigenartikel() {
    }

    protected Eigenartikel(String id) {
        super(id);
    }

    public boolean delete() {
        if (this.isProduct()) {
            List<Eigenartikel> packages = this.getPackages();
            for (Eigenartikel p : packages) {
                p.delete();
            }
        }
        return super.delete();
    }

    public boolean isProduct() {
        String extId = this.get("ExtID");
        return extId == null || extId.length() == 0;
    }

    public boolean isDragOK() {
        return true;
    }

    public String getInternalName() {
        return this.getLabel();
    }

    public IVerrechenbar.VatInfo getVatInfo() {
        EigenartikelTyp eat = this.getTyp();
        switch (eat) {
            case PHARMA: 
            case MAGISTERY: 
            case COMPLEMENTARY_REDUCED: {
                return IVerrechenbar.VatInfo.VAT_CH_ISMEDICAMENT;
            }
            case NONPHARMA: 
            case COMPLEMENTARY: {
                return IVerrechenbar.VatInfo.VAT_CH_NOTMEDICAMENT;
            }
        }
        return IVerrechenbar.VatInfo.VAT_NONE;
    }

    public static void copyProductAttributesToArticleSetAsChild(Eigenartikel product, Eigenartikel eaPackage) {
        ArrayList<Eigenartikel> eaPackages = new ArrayList<Eigenartikel>();
        if (eaPackage != null) {
            eaPackages.add(eaPackage);
        } else {
            Query qre = new Query(Eigenartikel.class);
            qre.add("ExtID", "=", product.getId());
            eaPackages.addAll(qre.execute());
        }
        for (Eigenartikel ea : eaPackages) {
            String[] keys = new String[]{"ExtID", "Codeclass", "ATC_code", "Typ", "Name"};
            String[] values = new String[]{product.getId(), product.get("Codeclass"), product.getATC_code(), product.get("Typ"), product.getName()};
            ea.set(keys, values);
        }
    }

    public String getPackageSizeLabel() {
        if (this.getPackageSizeString() != null && this.getPackageSizeString().length() > 0) {
            return this.getPackageSizeString();
        }
        if (this.getPackageSize() != null && this.getMeasurementUnit() != null) {
            return this.getPackageSize() + " " + this.getMeasurementUnit();
        }
        if (this.getPackageSize() != null) {
            return Integer.toString(this.getPackageSize());
        }
        return "";
    }

    public List<Eigenartikel> getPackages() {
        if (this.isProduct()) {
            Query qbe = new Query(Eigenartikel.class);
            qbe.add("ExtID", "=", this.getId());
            return qbe.execute();
        }
        return Collections.emptyList();
    }

    public EigenartikelTyp getTyp() {
        String value = this.get("Codeclass");
        return EigenartikelTyp.byCharSafe((String)value);
    }

    public void setTyp(EigenartikelTyp type) {
        this.set("Codeclass", Character.toString(type.getTypeChar()));
    }

    private Integer returnNaturalNumberIntegerOrNull(int value) {
        if (value > 0) {
            return value;
        }
        return null;
    }

    private int getNaturalIntOrZeroIfNull(Integer intVal) {
        if (intVal == null) {
            return 0;
        }
        return intVal;
    }

    public Integer getPackageSize() {
        return this.returnNaturalNumberIntegerOrNull(this.getPackungsGroesse());
    }

    public void setPackageSize(Integer packageSize) {
        this.setPackungsGroesse(this.getNaturalIntOrZeroIfNull(packageSize));
    }

    public void setPackageSizeString(String pss) {
        this.setExtInfoStoredObjectByKey("packageSizeString", pss);
    }

    public String getPackageSizeString() {
        return (String)this.getExtInfoStoredObjectByKey("packageSizeString");
    }

    public String getSellUnit() {
        return (String)this.getExtInfoStoredObjectByKey("Verkaufseinheit");
    }

    public void setSellUnit(String sellUnit) {
        this.setExtInfoStoredObjectByKey("Verkaufseinheit", sellUnit);
    }

    public void setMeasurementUnit(String mu) {
        this.setExtInfoStoredObjectByKey("measurementUnit", mu);
    }

    public String getMeasurementUnit() {
        return Eigenartikel.checkNull((Object)this.getExtInfoStoredObjectByKey("measurementUnit"));
    }

    public String getExfPrice() {
        return this.getEKPreis().getCentsAsString();
    }

    public void setExfPrice(String exfPrice) {
        Money m = new Money();
        m.addCent(exfPrice);
        this.setEKPreis(m);
    }

    public String getPharmaCode() {
        return this.get("SubID");
    }

    public void setPharmaCode(String pharmacode) {
        this.set("SubID", pharmacode);
    }

    public String getPubPrice() {
        return this.getVKPreis().getCentsAsString();
    }

    public void setPubPrice(String pubPrice) {
        Money m = new Money();
        m.addCent(pubPrice);
        this.setVKPreis(m);
    }

    public boolean isHealthInsuranceCostAbsorption() {
        return Boolean.valueOf((String)this.getExtInfoStoredObjectByKey("healthInsuranceCostAbsorption"));
    }

    public void setHealthInsuranceCostAbsorption(boolean hica) {
        this.setExtInfoStoredObjectByKey("healthInsuranceCostAbsorption", Boolean.toString(hica));
    }

    public boolean isValidPackage() {
        String extId = this.get("ExtID");
        return Eigenartikel.load(extId).isValid();
    }

    public IOptifier getOptifier() {
        if (OPTIFIER == null) {
            OPTIFIER = new IVerrechenbar.DefaultOptifier(){

                public Result<IVerrechenbar> add(IVerrechenbar code, Konsultation kons) {
                    Eigenartikel article;
                    boolean valid = true;
                    if (code instanceof Eigenartikel && (article = (Eigenartikel)code).getTyp() == EigenartikelTyp.COMPLEMENTARY) {
                        String gesetz = kons.getFall().getConfiguredBillingSystemLaw().name();
                        String system = kons.getFall().getAbrechnungsSystem();
                        if (gesetz.isEmpty()) {
                            if (!"vvg".equalsIgnoreCase(system)) {
                                valid = false;
                            }
                        } else if (!"vvg".equalsIgnoreCase(gesetz)) {
                            valid = false;
                        }
                    }
                    return valid ? super.add(code, kons) : new Result(Result.SEVERITY.WARNING, 0, "Komplement\u00e4rmedizinische Artikel k\u00f6nnen nur auf eine Fall mit Gesetz oder Name VVG verrechnet werden.", null, false);
                }
            };
        }
        return OPTIFIER;
    }
}

