/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class CheckKonsultationValidity
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder output = new StringBuilder();
        pm.beginTask("Check validity of konsultationen", 2);
        pm.subTask("Checking case references ...");
        Query qbe = new Query(Konsultation.class);
        List kons = qbe.execute();
        output.append("Konsultationen mit leerem oder ung\u00fcltigem Fall:\n");
        int counter = 0;
        for (Konsultation k : kons) {
            if (k.getFall() != null && k.getFall().exists()) continue;
            output.append("Kons.ID: " + k.getLabel() + " (" + k.getId() + ") , Datum: " + k.getDatum() + "\n");
            ++counter;
        }
        output = this.feedbackIfOK(output, counter);
        pm.worked(1);
        pm.subTask("Checking leistungs references ...");
        Query qbe1 = new Query(Verrechnet.class);
        List verrechnet = qbe1.execute();
        output.append("\nKonsultationen mit ung\u00fcltigen Leistungen:\n");
        counter = 0;
        for (Verrechnet v : verrechnet) {
            IVerrechenbar verrechenbar = v.getVerrechenbar();
            try {
                if (verrechenbar == null) continue;
                verrechenbar.getMinutes();
            }
            catch (NullPointerException npe) {
                if (v.getKons() == null) continue;
                output.append("Kons.ID: " + v.getKons().getLabel() + " (" + v.getKons().getId() + "), Patient: " + v.getKons().getFall().getPatient().getLabel() + ", LeistungsCode: " + v.get("Leistg_code") + ", Klasse: " + v.get("Klasse") + "\n");
                ++counter;
            }
        }
        output = this.feedbackIfOK(output, counter);
        pm.worked(1);
        output.append("\nPr\u00fcfung abgeschlossen.");
        pm.done();
        return output.toString();
    }

    private StringBuilder feedbackIfOK(StringBuilder output, int counter) {
        if (counter == 0) {
            output.append("Keine ung\u00fcltigen gefunden!");
        }
        return output;
    }

    @Override
    public String getMaintenanceDescription() {
        return "Konsultationen auf G\u00fcltigkeit \u00fcberpr\u00fcfen";
    }
}

