/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.cons;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ui.action.AddFindingAction;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;

public class KonsExtension
implements IKonsExtension {
    IRichTextDisplay mine;
    public static final String EXTENSION_ID = "ch.elexis.core.findings.ui.cons";
    private static final String FINDINGS_TITLE = "Befund: ";

    public String connect(IRichTextDisplay tf) {
        this.mine = tf;
        this.mine.addDropReceiver(IObservation.class, (IKonsExtension)this);
        return EXTENSION_ID;
    }

    public boolean doLayout(StyleRange styleRange, String provider, String id) {
        styleRange.background = UiDesk.getColor((String)"hellgrau");
        return true;
    }

    public boolean doXRef(String refProvider, String refID) {
        Optional observation = FindingsServiceComponent.getService().findById(refID, IObservation.class);
        observation.ifPresent(obs -> {
            Boolean ret = (Boolean)FindingsUiUtil.executeCommand("ch.elexis.core.findings.ui.commandEdit", (IFinding)obs);
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)obs));
        });
        return true;
    }

    public String updateXRef(String provider, String id) {
        Optional observation = FindingsServiceComponent.getService().findById(id, IObservation.class);
        if (observation.isPresent()) {
            return this.getXRefText((IFinding)observation.get());
        }
        return null;
    }

    public void updateXRef(Samdas.XRef xref) {
        if (this.mine instanceof EnhancedTextField) {
            ((EnhancedTextField)this.mine).updateXRef(xref);
        }
    }

    public void insert(Object o, int pos) {
        if (o instanceof IObservation) {
            IObservation observation = (IObservation)o;
            Konsultation k = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            this.mine.insertXRef(pos, this.getXRefText((IFinding)observation), EXTENSION_ID, ((PersistentObject)observation).getId());
            k.updateEintrag(this.mine.getContentsAsXML(), false);
            ElexisEventDispatcher.update((PersistentObject)k);
        }
    }

    public String getXRefText(IFinding finding) {
        return FINDINGS_TITLE + finding.getText().orElse("?");
    }

    public IAction[] getActions() {
        IAction[] ret = new IAction[]{new AddFindingAction(this)};
        return ret;
    }

    public void removeXRef(String refProvider, String refID) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

