/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.composites;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.ui.composites.ICompositeSaveable;
import ch.elexis.core.findings.ui.services.FindingsServiceComponent;
import ch.elexis.core.findings.ui.util.FindingsUiUtil;
import ch.elexis.core.findings.util.ModelUtil;
import ch.elexis.core.ui.util.SWTHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CompositeTextUnit
extends Composite
implements ICompositeSaveable {
    private Text fieldText;
    private IFinding iFinding;
    private ObservationComponent backboneComponent;
    private Label lblUnit;
    private Label lbl;
    private List<Action> toolbarActions = new ArrayList<Action>();
    private IObservation.ObservationType observationType;

    public CompositeTextUnit(Composite parent, IFinding iFinding, ObservationComponent backboneComponent) {
        super(parent, 0);
        this.iFinding = iFinding;
        this.backboneComponent = backboneComponent;
        GridLayout gd = new GridLayout(2, false);
        gd.marginTop = 5;
        gd.marginBottom = 0;
        gd.marginHeight = 0;
        gd.verticalSpacing = 0;
        this.setLayout((Layout)gd);
        this.setLayoutData(new GridData(4, 4, true, true));
        String unit = null;
        String numeric = null;
        List codings = null;
        String title = null;
        String textValue = null;
        if (backboneComponent != null) {
            this.observationType = (IObservation.ObservationType)backboneComponent.getTypeFromExtension(IObservation.ObservationType.class);
            if (IObservation.ObservationType.TEXT.equals((Object)this.observationType)) {
                textValue = backboneComponent.getStringValue().orElse("");
            } else if (IObservation.ObservationType.NUMERIC.equals((Object)this.observationType)) {
                unit = backboneComponent.getNumericValueUnit().orElse("");
                numeric = backboneComponent.getNumericValue().isPresent() ? ((BigDecimal)backboneComponent.getNumericValue().get()).toPlainString() : "";
            }
            codings = backboneComponent.getCoding();
        } else if (iFinding instanceof IObservation) {
            IObservation iObservation = (IObservation)iFinding;
            this.observationType = iObservation.getObservationType();
            if (IObservation.ObservationType.TEXT.equals((Object)iObservation.getObservationType())) {
                textValue = iObservation.getStringValue().orElse("");
            } else if (IObservation.ObservationType.NUMERIC.equals((Object)iObservation.getObservationType())) {
                unit = iObservation.getNumericValueUnit().orElse("");
                numeric = iObservation.getNumericValue().isPresent() ? ((BigDecimal)iObservation.getNumericValue().get()).toPlainString() : "";
            }
            codings = iObservation.getCoding();
        }
        if (title == null && codings != null) {
            Optional coding = ModelUtil.getCodeBySystem(codings, (CodingSystem)CodingSystem.ELEXIS_LOCAL_CODESYSTEM);
            String string = title = coding.isPresent() ? ((ICoding)coding.get()).getDisplay() : "";
        }
        if (title == null) {
            title = iFinding.getText().orElse("");
        }
        this.createContents(title, textValue, unit, numeric, backboneComponent != null);
    }

    private void createContents(String title, String textValue, String unit, String numeric, boolean componentChild) {
        Composite c = new Composite((Composite)this, 0);
        c.setLayout((Layout)SWTHelper.createGridLayout((boolean)true, (int)2));
        c.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.lbl = new Label(c, 0);
        this.lbl.setText(title);
        GridData minGD = new GridData(16384, 1024, true, false, 1, 1);
        this.lbl.setLayoutData((Object)minGD);
        if (numeric != null && unit != null) {
            if (!componentChild && this.iFinding instanceof IObservation) {
                this.toolbarActions.addAll(FindingsUiUtil.createToolbarSubComponents(c, (IObservation)this.iFinding, 1));
            }
            this.fieldText = new Text((Composite)this, 2048);
            this.fieldText.setLayoutData((Object)new GridData(4, 128, true, false));
            this.fieldText.setText(numeric);
            this.fieldText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String txt = e.text;
                    if (!txt.isEmpty()) {
                        StringBuilder builder = new StringBuilder(((Text)e.widget).getText());
                        if (e.start == e.end) {
                            builder.insert(e.start, txt);
                        } else {
                            builder.replace(e.start, e.end, txt);
                        }
                        if (!builder.toString().matches("-?(\\d+\\.)?\\d*$")) {
                            e.doit = false;
                        }
                    }
                }
            });
            this.lblUnit = new Label((Composite)this, 0);
            GridData gdUnit = new GridData(4, 128, false, false);
            gdUnit.widthHint = 40;
            this.lblUnit.setLayoutData((Object)gdUnit);
            this.lblUnit.setAlignment(0x1000000);
            this.lblUnit.setText(unit);
        }
        if (this.fieldText == null) {
            this.fieldText = new Text((Composite)this, 2562);
            GridData gdFieldText = new GridData(4, 128, true, false);
            gdFieldText.heightHint = 40;
            this.fieldText.setLayoutData((Object)gdFieldText);
            this.fieldText.setText(textValue != null ? textValue : "");
            Label lblTmp = new Label((Composite)this, 0);
            lblTmp.setText("");
            GridData gdUnit = new GridData(4, 128, false, false);
            gdUnit.widthHint = 40;
            lblTmp.setLayoutData((Object)gdUnit);
        }
    }

    @Override
    public IFinding saveContents(LocalDateTime localDateTime) {
        if (this.iFinding.getId() == null) {
            this.iFinding = FindingsServiceComponent.getService().create(this.iFinding.getClass());
        }
        return FindingsUiUtil.saveObservation((IObservation)this.iFinding, this, localDateTime);
    }

    @Override
    public void hideLabel(boolean all) {
        if (this.lblUnit != null && all) {
            this.lblUnit.setVisible(false);
            GridData minGD = new GridData(4, 128, false, false);
            minGD.widthHint = 0;
            minGD.heightHint = 0;
            this.lblUnit.setLayoutData((Object)minGD);
        }
        if (this.lbl != null) {
            this.fieldText.setToolTipText(this.lbl.getText());
            this.fieldText.setMessage(this.lbl.getText());
            this.lbl.setVisible(false);
            ((GridData)this.lbl.getLayoutData()).widthHint = 0;
            ((GridData)this.lbl.getLayoutData()).heightHint = 0;
        }
    }

    @Override
    public void setToolbarActions(List<Action> toolbarActions) {
        this.toolbarActions = toolbarActions;
    }

    @Override
    public List<Action> getToolbarActions() {
        return this.toolbarActions;
    }

    @Override
    public String getTitle() {
        return this.lbl != null ? this.lbl.getText() : "";
    }

    @Override
    public IFinding getFinding() {
        return this.iFinding;
    }

    @Override
    public List<ICompositeSaveable> getChildReferences() {
        return Collections.emptyList();
    }

    @Override
    public List<ICompositeSaveable> getChildComponents() {
        return Collections.emptyList();
    }

    @Override
    public String getFieldTextValue() {
        return this.fieldText != null ? this.fieldText.getText() : "";
    }

    @Override
    public ObservationComponent getObservationComponent() {
        return this.backboneComponent;
    }

    @Override
    public IObservation.ObservationType getObservationType() {
        return this.observationType;
    }
}

