/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.IObservation;
import ch.elexis.core.findings.IObservationLink;
import ch.elexis.core.findings.ObservationComponent;
import ch.elexis.core.findings.codes.CodingSystem;
import ch.elexis.core.findings.util.FindingsFormatUtil;
import ch.elexis.core.findings.util.model.CodingWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ModelUtil {
    private static FhirContext context = FhirContext.forDstu3();

    private static IParser getJsonParser() {
        return context.newJsonParser();
    }

    public static IBaseResource getAsResource(String jsonResource) {
        return ModelUtil.getJsonParser().parseResource(jsonResource);
    }

    public static Optional<IBaseResource> loadResource(IFinding finding) throws DataFormatException {
        IBaseResource resource = null;
        String rawContent = finding.getRawContent();
        if (rawContent != null && !rawContent.isEmpty()) {
            Optional<String> convertedContent;
            if (!FindingsFormatUtil.isCurrentFindingsFormat(rawContent) && (convertedContent = FindingsFormatUtil.convertToCurrentFindingsFormat(rawContent)).isPresent()) {
                rawContent = convertedContent.get();
            }
            resource = ModelUtil.getAsResource(rawContent);
        }
        return Optional.ofNullable(resource);
    }

    public static void saveResource(IBaseResource resource, IFinding finding) throws DataFormatException {
        if (resource != null) {
            String resourceJson = ModelUtil.getJsonParser().encodeResourceToString(resource);
            finding.setRawContent(resourceJson);
        }
    }

    public static void setCodingsToConcept(CodeableConcept codeableConcept, List<ICoding> coding) {
        codeableConcept.getCoding().clear();
        for (ICoding iCoding : coding) {
            codeableConcept.addCoding(new Coding(iCoding.getSystem(), iCoding.getCode(), iCoding.getDisplay()));
        }
    }

    public static List<ICoding> getCodingsFromConcept(CodeableConcept codeableConcept) {
        ArrayList<ICoding> ret = new ArrayList<ICoding>();
        List coding = codeableConcept.getCoding();
        for (Coding code : coding) {
            ret.add(new CodingWrapper(code));
        }
        return ret;
    }

    public static boolean isCodeInList(String system, String code, List<ICoding> list) {
        if (list != null && !list.isEmpty()) {
            for (ICoding iCoding : list) {
                if (!iCoding.getSystem().equals(system) || !iCoding.getCode().equals(code)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSystemInList(String system, List<ICoding> list) {
        if (list != null && !list.isEmpty()) {
            for (ICoding iCoding : list) {
                if (!iCoding.getSystem().equals(system)) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<ICoding> getCodeBySystem(List<ICoding> coding, CodingSystem codingSystem) {
        for (ICoding iCoding : coding) {
            if (!codingSystem.getSystem().equals(iCoding.getSystem())) continue;
            return Optional.of(iCoding);
        }
        return Optional.empty();
    }

    public static Optional<String> getNarrativeAsString(Narrative narrative) {
        String text = narrative.getDivAsString();
        if (text != null) {
            String divDecodedText = text.replaceAll("<div>|<div xmlns=\"http://www.w3.org/1999/xhtml\">|</div>|</ div>", "");
            divDecodedText = divDecodedText.replaceAll("<br/>|<br />", "\n").replaceAll("&amp;", "&").replaceAll("&gt;", ">").replaceAll("&lt;", "<").replaceAll("'&sect;'", "\u00a7");
            return Optional.of(divDecodedText);
        }
        return Optional.empty();
    }

    public static void setNarrativeFromString(Narrative narrative, String text) {
        text = ModelUtil.fixXhtmlContent(text);
        String divEncodedText = text.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\u00a7", "'&sect;'").replaceAll("&", "&amp;").replaceAll("(\r\n|\r|\n)", "<br />");
        narrative.setDivAsString(divEncodedText);
    }

    private static String fixXhtmlContent(String content) {
        content = content.replace('\u00a0', ' ');
        return content;
    }

    public static boolean isSameCoding(ICoding left, ICoding right) {
        return left.getSystem().equals(right.getSystem()) && left.getCode().equals(right.getCode());
    }

    public static void addCodingIfNotPresent(List<ICoding> coding, ICoding iCoding) {
        for (ICoding presentCoding : coding) {
            if (!ModelUtil.isSameCoding(presentCoding, iCoding)) continue;
            return;
        }
        coding.add(iCoding);
    }

    public static String getExactUnitOfComponent(List<ObservationComponent> observationComponents) {
        HashSet<String> units = new HashSet<String>();
        for (ObservationComponent child : observationComponents) {
            Optional valueUnit = child.getNumericValueUnit();
            if (valueUnit.isPresent()) {
                units.add((String)valueUnit.get());
                continue;
            }
            return null;
        }
        return units.size() == 1 ? (String)units.iterator().next() : null;
    }

    public static List<IObservation> getObservationChildren(IObservation iObservation, List<IObservation> list, int maxDepth) {
        if (maxDepth > 0) {
            List refChildrens = iObservation.getTargetObseravtions(IObservationLink.ObservationLinkType.REF);
            list.addAll(refChildrens);
            for (IObservation child : refChildrens) {
                ModelUtil.getObservationChildren(child, list, --maxDepth);
            }
        }
        return list;
    }

    public static IObservation getRootObservationRecursive(IObservation observation) {
        IObservation rootObservation = observation;
        List sources = observation.getSourceObservations(IObservationLink.ObservationLinkType.REF);
        if (sources != null && !sources.isEmpty()) {
            for (IObservation iObservation : sources) {
                rootObservation = ModelUtil.getRootObservationRecursive(iObservation);
            }
        }
        return rootObservation;
    }
}

