/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.mail.ui.handlers;

import ch.elexis.core.mail.MailAccount;
import ch.elexis.core.mail.MailMessage;
import ch.elexis.core.mail.ui.client.MailClientComponent;
import ch.elexis.data.Mandant;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;

public class SendMailNoUiHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MailAccount mailAccount = null;
        String accountId = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.accountid");
        if (StringUtils.isNotBlank((String)accountId)) {
            mailAccount = MailClientComponent.getMailClient().getAccount(accountId).orElse(null);
        }
        if (mailAccount == null && (mailAccount = this.getMailAccount(event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.mandant"))) == null) {
            Mandant mandant = Mandant.load((String)event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.mandant"));
            return "No account for mandant [" + mandant.getLabel(false) + "]";
        }
        String attachments = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.attachments");
        String to = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.to");
        if (StringUtils.isBlank((String)to)) {
            return "No to address";
        }
        String subject = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.subject");
        String text = event.getParameter("ch.elexis.core.mail.ui.sendMailNoUi.text");
        MailMessage message = new MailMessage().to(to).subject(StringUtils.defaultString((String)subject)).text(StringUtils.defaultString((String)text));
        if (attachments != null && !attachments.isEmpty()) {
            List<File> attachmentList = this.getAttachmentsList(attachments);
            for (File file : attachmentList) {
                message.addAttachment(file);
            }
        }
        if (MailClientComponent.getMailClient().sendMail(mailAccount, message)) {
            return null;
        }
        return MailClientComponent.getLastErrorMessage();
    }

    private MailAccount getMailAccount(String mandantId) {
        List accounts = MailClientComponent.getMailClient().getAccounts();
        for (String string : accounts) {
            Optional account = MailClientComponent.getMailClient().getAccount(string);
            if (!account.isPresent() || ((MailAccount)account.get()).getType() != MailAccount.TYPE.SMTP || !((MailAccount)account.get()).isForMandant(mandantId)) continue;
            return (MailAccount)account.get();
        }
        return null;
    }

    private List<File> getAttachmentsList(String attachments) {
        ArrayList<File> ret = new ArrayList<File>();
        if (attachments != null && !attachments.isEmpty()) {
            String[] parts;
            String[] stringArray = parts = attachments.split(":::");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                ret.add(new File(string));
                ++n2;
            }
        }
        return ret;
    }
}

