/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.pool.IObjectPool;
import com.phloc.commons.pool.ObjectPool;
import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerTimer;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.timing.StopWatch;
import com.phloc.commons.xml.XMLFactory;
import com.phloc.commons.xml.sax.CollectingSAXErrorHandler;
import com.phloc.commons.xml.sax.InputSourceFactory;
import com.phloc.commons.xml.serialize.DOMReaderSettings;
import com.phloc.commons.xml.serialize.IDOMReaderSettings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@ThreadSafe
public final class XMLReader {
    private static final IStatisticsHandlerTimer s_aDomTimerHdl = StatisticsManager.getTimerHandler(XMLReader.class.getName() + "$DOM");
    private static final IStatisticsHandlerTimer s_aDomSchemaTimerHdl = StatisticsManager.getTimerHandler(XMLReader.class.getName() + "$DOMwithSchema");
    private static final IStatisticsHandlerCounter s_aDomErrorCounterHdl = StatisticsManager.getCounterHandler(XMLReader.class.getName() + "$DOMERRORS");
    private static final IObjectPool<DocumentBuilder> s_aDOMPool = new ObjectPool<DocumentBuilder>(5, new DOMReaderFactory());
    private static final XMLReader s_aInstance = new XMLReader();

    private XMLReader() {
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource) throws SAXException {
        return XMLReader.readXMLDOM(inputSource, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream) throws SAXException {
        return XMLReader.readXMLDOM(inputStream, (IDOMReaderSettings)new DOMReaderSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        ValueEnforcer.notNull(inputStream, "InputStream");
        try {
            Document document = XMLReader.readXMLDOM(InputSourceFactory.create(inputStream), iDOMReaderSettings);
            return document;
        }
        finally {
            StreamUtils.close(inputStream);
        }
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader) throws SAXException {
        return XMLReader.readXMLDOM(reader, (IDOMReaderSettings)new DOMReaderSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        ValueEnforcer.notNull(reader, "Reader");
        try {
            Document document = XMLReader.readXMLDOM(InputSourceFactory.create(reader), iDOMReaderSettings);
            return document;
        }
        finally {
            StreamUtils.close(reader);
        }
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URI uRI) throws SAXException {
        return XMLReader.readXMLDOM(uRI, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URI uRI, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(uRI), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URL uRL) throws SAXException {
        return XMLReader.readXMLDOM(uRL, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URL uRL, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(uRL), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file) throws SAXException {
        return XMLReader.readXMLDOM(file, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(file), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource) throws SAXException {
        return XMLReader.readXMLDOM(iReadableResource, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(iReadableResource), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string) throws SAXException {
        return XMLReader.readXMLDOM(string, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(string), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull CharSequence charSequence) throws SAXException {
        return XMLReader.readXMLDOM(charSequence, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull CharSequence charSequence, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(charSequence), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull ByteBuffer byteBuffer) throws SAXException {
        return XMLReader.readXMLDOM(byteBuffer, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull ByteBuffer byteBuffer, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(byteBuffer), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray) throws SAXException {
        return XMLReader.readXMLDOM(byArray, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(byArray), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws SAXException {
        return XMLReader.readXMLDOM(byArray, n, n2, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(byArray, n, n2), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray) throws SAXException {
        return XMLReader.readXMLDOM(cArray, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(cArray), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws SAXException {
        return XMLReader.readXMLDOM(cArray, n, n2, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return XMLReader.readXMLDOM(InputSourceFactory.create(cArray, n, n2), iDOMReaderSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        ValueEnforcer.notNull(inputSource, "InputSource");
        ValueEnforcer.notNull(iDOMReaderSettings, "Settings");
        Document document = null;
        try {
            DocumentBuilder documentBuilder;
            Object object;
            StopWatch stopWatch = new StopWatch(true);
            boolean bl = false;
            if (iDOMReaderSettings.requiresNewXMLParser()) {
                object = DocumentBuilderFactory.newInstance();
                iDOMReaderSettings.applyToDocumentBuilderFactory((DocumentBuilderFactory)object);
                documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            } else {
                documentBuilder = s_aDOMPool.borrowObject();
                bl = true;
            }
            try {
                iDOMReaderSettings.applyToDocumentBuilder(documentBuilder);
                ErrorHandler errorHandler = iDOMReaderSettings.getErrorHandler();
                if (errorHandler instanceof CollectingSAXErrorHandler) {
                    object = (CollectingSAXErrorHandler)errorHandler;
                } else {
                    object = new CollectingSAXErrorHandler(errorHandler);
                    documentBuilder.setErrorHandler((ErrorHandler)object);
                }
                document = documentBuilder.parse(inputSource);
                if (iDOMReaderSettings.getSchema() == null) {
                    s_aDomTimerHdl.addTime(stopWatch.stopAndGetMillis());
                } else {
                    s_aDomSchemaTimerHdl.addTime(stopWatch.stopAndGetMillis());
                }
                if (((CollectingSAXErrorHandler)object).containsAtLeastOneError()) {
                    Document document2 = null;
                    return document2;
                }
            }
            finally {
                if (bl) {
                    s_aDOMPool.returnObject(documentBuilder);
                }
            }
        }
        catch (Throwable throwable) {
            iDOMReaderSettings.getExceptionHandler().onException(throwable);
            s_aDomErrorCounterHdl.increment();
            if (throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
        }
        finally {
            StreamUtils.close(inputSource.getByteStream());
            StreamUtils.close(inputSource.getCharacterStream());
        }
        return document;
    }

    static final class DOMReaderFactory
    implements IFactory<DocumentBuilder> {
        DOMReaderFactory() {
        }

        @Override
        @Nonnull
        public DocumentBuilder create() {
            return XMLFactory.createDocumentBuilder();
        }
    }
}

