/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.typeconvert.rule;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.typeconvert.ITypeConverterRule;
import com.phloc.commons.typeconvert.rule.AbstractTypeConverterRule;
import javax.annotation.Nonnull;

public abstract class AbstractTypeConverterRuleAssignableSourceFixedDestination
extends AbstractTypeConverterRule {
    private final Class<?> m_aSrcClass;
    private final Class<?> m_aDstClass;

    public AbstractTypeConverterRuleAssignableSourceFixedDestination(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        super(ITypeConverterRule.ESubType.ASSIGNABLE_SRC_FIXED_DST);
        this.m_aSrcClass = ValueEnforcer.notNull(clazz, "SrcClass");
        this.m_aDstClass = ValueEnforcer.notNull(clazz2, "DestClass");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        return this.m_aDstClass.equals(clazz2) && this.m_aSrcClass.isAssignableFrom(clazz);
    }

    @Nonnull
    public final Class<?> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Nonnull
    public final Class<?> getDestinationClass() {
        return this.m_aDstClass;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("srcClass", this.m_aSrcClass.getName()).append("dstClass", this.m_aDstClass.getName()).toString();
    }
}

