/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.actions;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.laboratory.controls.LaborOrderViewerItem;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;

public class LaborResultOrderDeleteAction
extends Action
implements IAction {
    private List<?> selectedOrdersOrResults;
    private final Shell shell;
    private final StructuredViewer viewer;

    public LaborResultOrderDeleteAction(List<?> list, StructuredViewer viewer) {
        super(Messages.LabResultOrOrderDeleteAction_title);
        this.selectedOrdersOrResults = list;
        this.viewer = viewer;
        this.shell = viewer.getControl().getShell();
    }

    public LaborResultOrderDeleteAction(List<?> list, Shell shell) {
        super(Messages.LabResultOrOrderDeleteAction_title);
        this.selectedOrdersOrResults = list;
        this.viewer = null;
        this.shell = shell;
    }

    public void run() {
        for (Object object : this.selectedOrdersOrResults) {
            LabResult result;
            LabOrder order;
            if (object instanceof LabOrder) {
                order = (LabOrder)object;
                result = (LabResult)order.getLabResult();
            } else if (object instanceof LabResult) {
                result = (LabResult)object;
                order = result.getLabOrder();
            } else if (object instanceof LaborOrderViewerItem) {
                result = ((LaborOrderViewerItem)object).getLabResult();
                order = ((LaborOrderViewerItem)object).getLabOrder();
            } else {
                throw new IllegalArgumentException("Unknown list entry type of class " + object.getClass());
            }
            boolean delete = MessageDialog.openConfirm((Shell)this.shell, (String)"Resultat/Verordnung entfernen", (String)("Soll das Resultat [" + result + "] sowie die zugeh. Verordnung wirklich entfernt werden?"));
            if (!delete) continue;
            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)result, (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    if (result != null) {
                        result.delete();
                    }
                    if (order != null) {
                        order.delete();
                    }
                    if (LaborResultOrderDeleteAction.this.viewer != null) {
                        LaborResultOrderDeleteAction.this.viewer.refresh();
                    }
                }
            });
            ElexisEventDispatcher.reload(LabResult.class);
        }
    }

    public boolean isEnabled() {
        return this.selectedOrdersOrResults != null && !this.selectedOrdersOrResults.isEmpty();
    }
}

