/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings;

import ch.elexis.core.findings.ICoding;
import ch.elexis.core.findings.IObservation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ObservationComponent {
    private List<ICoding> coding = new ArrayList<ICoding>();
    private BigDecimal numericValue;
    private String numericValueUnit;
    private String stringValue;
    private final String id;
    private Map<String, String> extensions = new HashMap<String, String>();
    public static final String EXTENSION_OBSERVATION_TYPE_URL = "www.elexis.info/observation/type";

    public ObservationComponent(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public List<ICoding> getCoding() {
        return this.coding;
    }

    public void setCoding(List<ICoding> coding) {
        this.coding = coding;
    }

    public Optional<BigDecimal> getNumericValue() {
        return Optional.ofNullable(this.numericValue);
    }

    public void setNumericValue(BigDecimal numericValue) {
        this.numericValue = numericValue;
        this.getExtensions().put(EXTENSION_OBSERVATION_TYPE_URL, IObservation.ObservationType.NUMERIC.name());
    }

    public Optional<String> getNumericValueUnit() {
        return Optional.ofNullable(this.numericValueUnit);
    }

    public void setNumericValueUnit(String numericValueUnit) {
        this.numericValueUnit = numericValueUnit;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
        this.getExtensions().put(EXTENSION_OBSERVATION_TYPE_URL, IObservation.ObservationType.TEXT.name());
    }

    public Optional<String> getStringValue() {
        return Optional.ofNullable(this.stringValue);
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public <T> T getTypeFromExtension(Class<T> clazz) {
        String type = null;
        if (clazz.equals(IObservation.ObservationType.class) && (type = this.getExtensions().get(EXTENSION_OBSERVATION_TYPE_URL)) != null) {
            return clazz.cast((Object)IObservation.ObservationType.valueOf(type));
        }
        return null;
    }
}

