/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.util.MultiplikatorList;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Comparator;

public abstract class VerrechenbarAdapter
extends PersistentObject
implements IVerrechenbar {
    @Override
    public String getLabel() {
        return this.getText();
    }

    @Override
    protected abstract String getTableName();

    public String getCode() {
        return null;
    }

    public String getCodeSystemName() {
        return null;
    }

    public String getText() {
        return null;
    }

    @Override
    public IOptifier getOptifier() {
        return optifier;
    }

    @Override
    public Comparator<IVerrechenbar> getComparator() {
        return comparator;
    }

    @Override
    public IFilter getFilter(Mandant m) {
        return ifilter;
    }

    public void setVKMultiplikator(TimeTool von, TimeTool bis, double factor, String typ) {
        StringBuilder sql = new StringBuilder();
        String eoue = new TimeTool("20380118").toString(9);
        if (bis == null) {
            bis = new TimeTool("20380118");
        }
        String from = von.toString(9);
        JdbcLink.Stm stm = VerrechenbarAdapter.getConnection().getStatement();
        sql.append("UPDATE VK_PREISE SET DATUM_BIS=").append(JdbcLink.wrap((String)from)).append(" WHERE (DATUM_BIS=").append(JdbcLink.wrap((String)eoue)).append(" OR DATUM_BIS='99991231') AND TYP=").append(JdbcLink.wrap((String)typ));
        stm.exec(sql.toString());
        sql.setLength(0);
        sql.append("INSERT INTO VK_PREISE (ID,DATUM_VON,DATUM_BIS,MULTIPLIKATOR,TYP) VALUES (").append(JdbcLink.wrap((String)StringTool.unique((String)"rtsu"))).append(",").append(JdbcLink.wrap((String)von.toString(9))).append(",").append(JdbcLink.wrap((String)bis.toString(9))).append(",").append(JdbcLink.wrap((String)Double.toString(factor))).append(",").append(JdbcLink.wrap((String)typ)).append(");");
        stm.exec(sql.toString());
        VerrechenbarAdapter.getConnection().releaseStatement(stm);
    }

    public double getVKMultiplikator(TimeTool date, String typ) {
        return this.getMultiplikator(date, "VK_PREISE", typ);
    }

    public double getVKMultiplikator(TimeTool date, IFall fall) {
        return this.getMultiplikator(date, "VK_PREISE", fall.getAbrechnungsSystem());
    }

    public double getEKMultiplikator(TimeTool date, IFall fall) {
        return this.getMultiplikator(date, "EK_PREISE", fall.getAbrechnungsSystem());
    }

    private double getMultiplikator(TimeTool date, String table, String typ) {
        MultiplikatorList multis = new MultiplikatorList(table, typ);
        return multis.getMultiplikator(date);
    }

    @Override
    public Money getKosten(TimeTool dat) {
        return new Money(0);
    }

    @Override
    public int getMinutes() {
        return 0;
    }

    protected VerrechenbarAdapter(String id) {
        super(id);
    }

    protected VerrechenbarAdapter() {
    }

    @Override
    public IVerrechenbar.VatInfo getVatInfo() {
        return IVerrechenbar.VatInfo.VAT_DEFAULT;
    }
}

