/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Zahlung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AccountTransaction
extends PersistentObject {
    private static final String ACCOUNTS_CONFIG = "ch.elexis.core.data/accounttransaction/accounts";
    private static final String ACCOUNTS_SEPARATOR = "||";
    public static final String FLD_REMARK = "Bemerkung";
    public static final String FLD_AMOUNT = "Betrag";
    public static final String FLD_ACCOUNT = "account";
    public static final String FLD_BILL_ID = "RechnungsID";
    public static final String FLD_PAYMENT_ID = "ZahlungsID";
    public static final String FLD_PATIENT_ID = "PatientID";
    private static final String TABLENAME = "KONTO";

    static {
        AccountTransaction.addMapping(TABLENAME, FLD_PATIENT_ID, FLD_PAYMENT_ID, FLD_BILL_ID, FLD_AMOUNT, "Datum=S:D:Datum", FLD_REMARK, FLD_ACCOUNT);
    }

    public AccountTransaction(Patient pat, Rechnung r, Money betrag, String date, String bemerkung) {
        this.create(null);
        if (date == null) {
            date = new TimeTool().toString(4);
        }
        this.set(new String[]{FLD_AMOUNT, "Datum", FLD_REMARK}, betrag.getCentsAsString(), date, bemerkung);
        if (pat != null && pat.exists()) {
            this.set(FLD_PATIENT_ID, pat.getId());
        }
        if (r != null) {
            this.set(FLD_BILL_ID, r.getId());
        }
    }

    public AccountTransaction(Zahlung z) {
        this.create(null);
        Rechnung r = z.getRechnung();
        Patient p = r.getFall().getPatient();
        this.set(new String[]{FLD_PATIENT_ID, FLD_AMOUNT, "Datum", FLD_REMARK, FLD_BILL_ID, FLD_PAYMENT_ID}, p.getId(), z.getBetrag().getCentsAsString(), z.getDatum(), z.getBemerkung(), r.getId(), z.getId());
    }

    public void setAccount(Account account) {
        this.set(FLD_ACCOUNT, Integer.toString(account.getNumeric()));
    }

    public Account getAccount() {
        String accountNumeric = this.get(FLD_ACCOUNT);
        if (accountNumeric != null && !accountNumeric.isEmpty()) {
            try {
                accountNumeric = accountNumeric.trim();
                return Account.getAccounts().get(Integer.parseInt(accountNumeric));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Account.UNKNOWN;
    }

    public String getDate() {
        return this.get("Datum");
    }

    public Money getAmount() {
        try {
            return new Money(AccountTransaction.checkZero(this.get(FLD_AMOUNT)));
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return new Money();
        }
    }

    public String getRemark() {
        return AccountTransaction.checkNull(this.get(FLD_REMARK));
    }

    public Patient getPatient() {
        return Patient.load(this.get(FLD_PATIENT_ID));
    }

    public Rechnung getRechnung() {
        return Rechnung.load(this.get(FLD_BILL_ID));
    }

    public Zahlung getZahlung() {
        String zi = this.get(FLD_PAYMENT_ID);
        if (StringTool.isNothing((Object)zi)) {
            return null;
        }
        return Zahlung.load(zi);
    }

    @Override
    public boolean delete() {
        Zahlung z = this.getZahlung();
        if (z != null) {
            z.delete();
        }
        return super.delete();
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.get("Datum")).append(" ").append(this.get(FLD_AMOUNT)).append(" ").append(this.get(FLD_REMARK));
        Account account = this.getAccount();
        if (account != Account.UNKNOWN) {
            sb.append(" ").append(account.getName());
        }
        return sb.toString();
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public static AccountTransaction load(String id) {
        return new AccountTransaction(id);
    }

    protected AccountTransaction(String id) {
        super(id);
    }

    protected AccountTransaction() {
    }

    public static class Account {
        private int numeric;
        private String name;
        public static Account UNKNOWN = new Account(-1, "");
        private static HashMap<Integer, Account> localCache;

        private static List<Account> loadAccounts() {
            String accountsString;
            ArrayList<Account> ret = new ArrayList<Account>();
            ret.add(UNKNOWN);
            if (CoreHub.globalCfg != null && (accountsString = CoreHub.globalCfg.get(AccountTransaction.ACCOUNTS_CONFIG, "")) != null && !accountsString.isEmpty()) {
                String[] accounts;
                String[] stringArray = accounts = accountsString.split("\\|\\|");
                int n = accounts.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String[] parts = string.split("\\|");
                    if (parts.length == 2) {
                        ret.add(new Account(Integer.parseInt(parts[0]), parts[1]));
                    }
                    ++n2;
                }
            }
            return ret;
        }

        public static HashMap<Integer, Account> getAccounts() {
            if (localCache == null) {
                Account.loadCache();
            }
            return localCache;
        }

        private static void loadCache() {
            localCache = new HashMap();
            List<Account> accounts = Account.loadAccounts();
            for (Account account : accounts) {
                localCache.put(account.getNumeric(), account);
            }
        }

        public static void removeAccount(Account account) {
            List<Account> accounts = Account.loadAccounts();
            Iterator<Account> iterator = accounts.iterator();
            while (iterator.hasNext()) {
                Account existingAccount = iterator.next();
                if (existingAccount.getNumeric() != account.getNumeric()) continue;
                iterator.remove();
            }
            Account.setAccounts(accounts);
        }

        public static void addAccount(Account newAccount) {
            if (CoreHub.globalCfg != null) {
                String existingString = CoreHub.globalCfg.get(AccountTransaction.ACCOUNTS_CONFIG, "");
                StringBuilder sb = new StringBuilder();
                sb.append(existingString);
                if (sb.length() > 0) {
                    sb.append(AccountTransaction.ACCOUNTS_SEPARATOR);
                }
                sb.append(newAccount.getNumeric()).append("|").append(newAccount.getName());
                CoreHub.globalCfg.set(AccountTransaction.ACCOUNTS_CONFIG, sb.toString());
                Account.loadCache();
            }
        }

        public static void setAccounts(List<Account> accounts) {
            if (CoreHub.globalCfg != null) {
                StringBuilder sb = new StringBuilder();
                for (Account account : accounts) {
                    if (account.getNumeric() == -1) continue;
                    if (sb.length() > 0) {
                        sb.append(AccountTransaction.ACCOUNTS_SEPARATOR);
                    }
                    sb.append(account.getNumeric()).append("|").append(account.getName());
                }
                CoreHub.globalCfg.set(AccountTransaction.ACCOUNTS_CONFIG, sb.toString());
                Account.loadCache();
            }
        }

        public static void initDefaults() {
            HashMap<Integer, Account> existingAccounts = Account.getAccounts();
            if (!existingAccounts.containsKey(new Integer(1000))) {
                Account.addAccount(new Account(1000, "Kasse"));
            }
            if (!existingAccounts.containsKey(new Integer(1100))) {
                Account.addAccount(new Account(1100, "Post"));
            }
            if (!existingAccounts.containsKey(new Integer(1200))) {
                Account.addAccount(new Account(1200, "BESR"));
            }
            if (!existingAccounts.containsKey(new Integer(1201))) {
                Account.addAccount(new Account(1201, "Manuelle Bankeing\u00e4nge"));
            }
            if (!existingAccounts.containsKey(new Integer(1209))) {
                Account.addAccount(new Account(1209, "EFT-Zahlungen"));
            }
            if (!existingAccounts.containsKey(new Integer(4590))) {
                Account.addAccount(new Account(4590, "Differenz"));
            }
            if (!existingAccounts.containsKey(new Integer(4595))) {
                Account.addAccount(new Account(4595, "Debitorenverlust"));
            }
            if (!existingAccounts.containsKey(new Integer(6060))) {
                Account.addAccount(new Account(6060, "Mahngeb\u00fchren (Ertrag)"));
            }
            if (!existingAccounts.containsKey(new Integer(9999))) {
                Account.addAccount(new Account(9999, "Diverses"));
            }
        }

        public Account(int numeric, String name) {
            this.numeric = numeric;
            this.name = name;
        }

        public int getNumeric() {
            return this.numeric;
        }

        public String getName() {
            return this.name;
        }

        public void setNumeric(Integer numeric) {
            this.numeric = numeric;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

