/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.service;

import ch.elexis.core.common.ElexisEvent;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.internal.StockCommissioningSystemDriverFactories;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.stock.ICommissioningSystemDriver;
import ch.elexis.core.services.IStockCommissioningSystemService;
import ch.elexis.data.StockEntry;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class StockCommissioningSystemService
implements IStockCommissioningSystemService {
    public List<UUID> listAllAvailableDrivers() {
        return StockCommissioningSystemDriverFactories.getAllDriverUuids();
    }

    public String getInfoStringForDriver(UUID driverUuid, boolean extended) {
        return StockCommissioningSystemDriverFactories.getInfoStringForDriver(driverUuid, extended);
    }

    public IStatus initializeStockCommissioningSystem(IStock stock) {
        return Status.OK_STATUS;
    }

    public IStatus performArticleOutlay(IStockEntry stockEntry, int quantity, Map<String, Object> data) {
        StockEntry se = (StockEntry)stockEntry;
        if (se == null) {
            return new Status(4, "ch.elexis.core.data", "stock entry is null");
        }
        ElexisEvent performOutlayEvent = new ElexisEvent();
        performOutlayEvent.setTopic("info/elexis/stockCommissioning/outlay");
        performOutlayEvent.getProperties().put("stockEntryId", se.getId());
        performOutlayEvent.getProperties().put("quantity", Integer.toString(quantity));
        return CoreHub.getElexisServerEventService().postEvent(performOutlayEvent);
    }

    public ICommissioningSystemDriver getDriverInstanceForStock(IStock stock) {
        return null;
    }

    public IStatus synchronizeInventory(IStock stock, List<String> articleIds, Map<String, Object> data) {
        ElexisEvent synchronizeEvent = new ElexisEvent();
        synchronizeEvent.setTopic("info/elexis/stockCommissioning/updateStock");
        synchronizeEvent.getProperties().put("stockId", stock.getId());
        return CoreHub.getElexisServerEventService().postEvent(synchronizeEvent);
    }

    public IStatus initializeInstancesUsingDriver(UUID driver) {
        return Status.OK_STATUS;
    }

    public IStatus shutdownInstancesUsingDriver(UUID driver) {
        return Status.OK_STATUS;
    }

    public IStatus shutdownStockCommissioningSytem(IStock stock) {
        return Status.OK_STATUS;
    }
}

