/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.interfaces;

import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.data.interfaces.IOptifier;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Mandant;
import ch.elexis.data.Verrechnet;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IVerrechenbar
extends ICodeElement {
    public static final IOptifier optifier = new DefaultOptifier();
    public static final Comparator<IVerrechenbar> comparator = new DefaultComparator();
    public static final IFilter ifilter = new DefaultFilter();

    public IOptifier getOptifier();

    public Comparator<IVerrechenbar> getComparator();

    public IFilter getFilter(Mandant var1);

    public int getTP(@NonNull TimeTool var1, @Nullable IFall var2);

    default public int getTP(@NonNull TimeTool date, @Nullable Konsultation kons) {
        if (kons != null) {
            return this.getTP(date, kons.getFall());
        }
        return this.getTP(date, (IFall)null);
    }

    public double getFactor(TimeTool var1, IFall var2);

    public Money getKosten(TimeTool var1);

    public int getMinutes();

    public String getXidDomain();

    public VatInfo getVatInfo();

    public static class DefaultComparator
    implements Comparator<IVerrechenbar> {
        @Override
        public int compare(IVerrechenbar v1, IVerrechenbar v2) {
            int i = v1.getCodeSystemName().compareTo(v2.getCodeSystemName());
            if (i == 0) {
                i = v1.getCode().compareTo(v2.getCode());
            }
            return i;
        }
    }

    public static class DefaultFilter
    implements IFilter {
        public boolean select(Object toTest) {
            return true;
        }
    }

    public static class DefaultOptifier
    implements IOptifier {
        private Logger log;
        private Verrechnet newVerrechnet;

        @Override
        public Result<Object> optify(Konsultation kons) {
            return new Result((Object)kons);
        }

        @Override
        public Result<IVerrechenbar> add(IVerrechenbar code, Konsultation kons) {
            List<Verrechnet> old = kons.getLeistungen();
            Verrechnet foundVerrechnet = null;
            for (Verrechnet verrechnet : old) {
                IVerrechenbar vrElement = verrechnet.getVerrechenbar();
                if (vrElement == null) {
                    if (this.log == null) {
                        this.log = LoggerFactory.getLogger(DefaultOptifier.class);
                    }
                    this.log.error("IVerrechenbar is not resolvable in " + verrechnet.getId() + " is " + verrechnet.get("Klasse") + " available?");
                    continue;
                }
                if (!vrElement.getId().equals(code.getId()) || !verrechnet.getText().equals(code.getText())) continue;
                foundVerrechnet = verrechnet;
                break;
            }
            if (foundVerrechnet != null) {
                foundVerrechnet.changeAnzahl(foundVerrechnet.getZahl() + 1);
            } else {
                this.newVerrechnet = new Verrechnet(code, kons, 1);
                old.add(this.newVerrechnet);
            }
            return new Result((Object)code);
        }

        @Override
        public Result<Verrechnet> remove(Verrechnet v, Konsultation kons) {
            List<Verrechnet> old = kons.getLeistungen();
            old.remove(v);
            v.delete();
            return new Result(null);
        }

        @Override
        public Verrechnet getCreatedVerrechnet() {
            return this.newVerrechnet;
        }
    }

    public static enum VatInfo {
        VAT_DEFAULT,
        VAT_NONE,
        VAT_CH_ISMEDICAMENT,
        VAT_CH_NOTMEDICAMENT,
        VAT_CH_ISTREATMENT,
        VAT_CH_NOTTREATMENT;


        public static String encodeAsString(EnumSet<VatInfo> set) {
            StringBuilder sb = new StringBuilder();
            for (VatInfo info : set) {
                if (sb.length() == 0) {
                    sb.append(info.name());
                    continue;
                }
                sb.append("," + info.name());
            }
            return sb.toString();
        }

        public static EnumSet<VatInfo> decodeFromString(String code) {
            String[] names = code.split(",");
            EnumSet<VatInfo> ret = EnumSet.noneOf(VatInfo.class);
            int i = 0;
            while (i < names.length) {
                ret.add(VatInfo.valueOf(names[i]));
                ++i;
            }
            return ret;
        }
    }
}

