/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.data.events;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisContext;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.data.server.ServerEventMapper;
import ch.elexis.core.data.status.ElexisStatus;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.Anwender;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.ListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElexisEventDispatcher
implements Runnable {
    private Logger log = LoggerFactory.getLogger(ElexisEventDispatcher.class);
    private final ListenerList<ElexisEventListener> listeners = new ListenerList();
    private static ElexisEventDispatcher theInstance;
    private final PriorityQueue<ElexisEvent> eventQueue = new PriorityQueue(50);
    private final ArrayList<ElexisEvent> eventCopy = new ArrayList(50);
    private transient boolean bStop = false;
    private final ElexisContext elexisUIContext = new ElexisContext();
    private List<Integer> blockEventTypes;
    private volatile IPerformanceStatisticHandler performanceStatisticHandler;
    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    public static synchronized ElexisEventDispatcher getInstance() {
        if (theInstance == null) {
            theInstance = new ElexisEventDispatcher();
        }
        return theInstance;
    }

    private ElexisEventDispatcher() {
        this.service.scheduleAtFixedRate(this, 0L, 25L, TimeUnit.MILLISECONDS);
    }

    public void addListeners(ElexisEventListener ... els) {
        ElexisEventListener[] elexisEventListenerArray = els;
        int n = els.length;
        int n2 = 0;
        while (n2 < n) {
            ElexisEventListener el = elexisEventListenerArray[n2];
            this.listeners.add((Object)el);
            ++n2;
        }
    }

    public void removeListeners(ElexisEventListener ... els) {
        ElexisEventListener[] elexisEventListenerArray = els;
        int n = els.length;
        int n2 = 0;
        while (n2 < n) {
            ElexisEventListener el = elexisEventListenerArray[n2];
            this.listeners.remove((Object)el);
            ++n2;
        }
    }

    public void fireMessageEvent(MessageEvent me) {
        ElexisEvent ev = new ElexisEvent(me, MessageEvent.class, 1024, 1);
        this.fire(ev);
    }

    public synchronized void setBlockEventTypes(List<Integer> blockEventTypes) {
        this.blockEventTypes = blockEventTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fire(ElexisEvent ... ees) {
        ElexisEvent[] elexisEventArray = ees;
        int n = ees.length;
        int n2 = 0;
        while (n2 < n) {
            ElexisEvent ee = elexisEventArray[n2];
            if (this.blockEventTypes == null || !this.blockEventTypes.contains(ee.getType())) {
                if (ee.getPriority() == 1 && ee.getType() != 16) {
                    this.doDispatch(ee);
                } else {
                    Collection<ElexisEvent> eventsToThrow;
                    int eventType = ee.getType();
                    if (eventType == 16 || eventType == 32) {
                        eventsToThrow = null;
                        eventsToThrow = this.elexisUIContext.setSelection(ee.getObjectClass(), eventType == 16 ? ee.getObject() : null);
                        for (ElexisEvent elexisEvent : eventsToThrow) {
                            PriorityQueue<ElexisEvent> priorityQueue = this.eventQueue;
                            synchronized (priorityQueue) {
                                this.eventQueue.offer(elexisEvent);
                            }
                        }
                    } else {
                        ch.elexis.core.common.ElexisEvent mapEvent;
                        if (eventType == 128) {
                            this.elexisUIContext.setSelection(Mandant.class, ee.getObject());
                        } else if (eventType == 64) {
                            this.elexisUIContext.setSelection(Anwender.class, ee.getObject());
                        }
                        eventsToThrow = this.eventQueue;
                        synchronized (eventsToThrow) {
                            this.eventQueue.offer(ee);
                        }
                        if (CoreHub.getElexisServerEventService().deliversRemoteEvents() && (mapEvent = ServerEventMapper.mapEvent(ee)) != null) {
                            CoreHub.getElexisServerEventService().postEvent(mapEvent);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public static void fireElexisStatusEvent(ElexisStatus es) {
        ElexisEvent statusEvent = new ElexisEvent((Object)es, ElexisStatus.class, 256, 1);
        ElexisEventDispatcher.getInstance().doDispatch(statusEvent);
    }

    public static IPersistentObject getSelected(Class<?> template) {
        return ElexisEventDispatcher.getInstance().elexisUIContext.getSelected(template);
    }

    public static void fireSelectionEvent(PersistentObject po) {
        if (po != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 16));
        }
    }

    public static void fireSelectionEvents(PersistentObject ... objects) {
        if (objects != null) {
            ElexisEvent[] ees = new ElexisEvent[objects.length];
            int i = 0;
            while (i < objects.length) {
                ees[i] = new ElexisEvent(objects[i], objects[i].getClass(), 16);
                ++i;
            }
            ElexisEventDispatcher.getInstance().fire(ees);
        }
    }

    public static void clearSelection(Class<?> clazz) {
        if (clazz != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, clazz, 32));
        }
    }

    public static void reload(Class<?> clazz) {
        if (clazz != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(null, clazz, 8));
        }
    }

    public static void update(PersistentObject po) {
        if (po != null) {
            ElexisEventDispatcher.getInstance().fire(new ElexisEvent(po, po.getClass(), 4));
        }
    }

    @Nullable
    public static Patient getSelectedPatient() {
        return (Patient)ElexisEventDispatcher.getSelected(Patient.class);
    }

    @Nullable
    public static Mandant getSelectedMandator() {
        return (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
    }

    public void shutDown() {
        this.bStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PriorityQueue<ElexisEvent> priorityQueue = this.eventQueue;
        synchronized (priorityQueue) {
            while (!this.eventQueue.isEmpty()) {
                this.eventCopy.add(this.eventQueue.poll());
            }
            this.eventQueue.notifyAll();
        }
        for (ElexisEvent event : this.eventCopy) {
            this.doDispatch(event);
        }
        this.eventCopy.clear();
        if (this.bStop) {
            this.service.shutdown();
        }
    }

    private void doDispatch(ElexisEvent ee) {
        if (ee != null) {
            for (ElexisEventListener l : this.listeners) {
                if (!ee.matches(l.getElexisEventFilter())) continue;
                if (this.performanceStatisticHandler != null) {
                    this.startStatistics(ee, l);
                }
                try {
                    l.catchElexisEvent(ee);
                }
                catch (Exception e) {
                    this.log.error(ee.toString(), (Throwable)e);
                    throw e;
                }
                if (this.performanceStatisticHandler == null) continue;
                this.endStatistics(ee, l);
            }
        }
    }

    private void endStatistics(ElexisEvent ee, ElexisEventListener l) {
        if (!(l instanceof ElexisEventListenerImpl)) {
            this.performanceStatisticHandler.endCatchEvent(ee, l);
        }
    }

    private void startStatistics(ElexisEvent ee, ElexisEventListener l) {
        if (l instanceof ElexisEventListenerImpl) {
            ((ElexisEventListenerImpl)l).setPerformanceStatisticHandler(this.performanceStatisticHandler);
        } else {
            this.performanceStatisticHandler.startCatchEvent(ee, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilEventQueueIsEmpty(long millis) {
        block6: {
            PriorityQueue<ElexisEvent> priorityQueue = this.eventQueue;
            synchronized (priorityQueue) {
                if (this.eventQueue.isEmpty()) break block6;
                try {
                    this.eventQueue.wait(millis);
                    return true;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        return false;
    }

    public void dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("ElexisEventDispatcher dump: \n");
        for (ElexisEventListener el : this.listeners) {
            ElexisEvent filter = el.getElexisEventFilter();
            sb.append(el.getClass().getName()).append(": ");
            if (filter != null && filter.getObjectClass() != null && filter.getObjectClass().getName() != null) {
                sb.append(filter.type).append(" / ").append(filter.getObjectClass().getName());
            }
            sb.append("\n");
        }
        sb.append("\n--------------\n");
        this.log.debug(sb.toString());
    }

    public void setPerformanceStatisticHandler(IPerformanceStatisticHandler handler) {
        this.performanceStatisticHandler = handler;
    }

    public static interface IPerformanceStatisticHandler {
        public void startCatchEvent(ElexisEvent var1, ElexisEventListener var2);

        public void endCatchEvent(ElexisEvent var1, ElexisEventListener var2);
    }
}

