/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CQ;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.model.v251.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PDC
extends AbstractSegment {
    public PDC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(XON.class, true, 0, 250, new Object[]{this.getMessage()}, "Manufacturer/Distributor");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Country");
            this.add(ST.class, true, 1, 60, new Object[]{this.getMessage()}, "Brand Name");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Device Family Name");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Generic Name");
            this.add(ST.class, false, 0, 60, new Object[]{this.getMessage()}, "Model Identifier");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Catalogue Identifier");
            this.add(ST.class, false, 0, 60, new Object[]{this.getMessage()}, "Other Identifier");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Product Code");
            this.add(ID.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(330)}, "Marketing Basis");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Marketing Approval ID");
            this.add(CQ.class, false, 1, 12, new Object[]{this.getMessage()}, "Labeled Shelf Life");
            this.add(CQ.class, false, 1, 12, new Object[]{this.getMessage()}, "Expected Shelf Life");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date First Marketed");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Date Last Marketed");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PDC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public XON[] getManufacturerDistributor() {
        XON[] retVal = (XON[])this.getTypedField(1, new XON[0]);
        return retVal;
    }

    public XON[] getPdc1_ManufacturerDistributor() {
        XON[] retVal = (XON[])this.getTypedField(1, new XON[0]);
        return retVal;
    }

    public int getManufacturerDistributorReps() {
        return this.getReps(1);
    }

    public XON getManufacturerDistributor(int rep) {
        XON retVal = (XON)this.getTypedField(1, rep);
        return retVal;
    }

    public XON getPdc1_ManufacturerDistributor(int rep) {
        XON retVal = (XON)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPdc1_ManufacturerDistributorReps() {
        return this.getReps(1);
    }

    public XON insertManufacturerDistributor(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(1, rep);
    }

    public XON insertPdc1_ManufacturerDistributor(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(1, rep);
    }

    public XON removeManufacturerDistributor(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(1, rep);
    }

    public XON removePdc1_ManufacturerDistributor(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(1, rep);
    }

    public CE getCountry() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getPdc2_Country() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getBrandName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getPdc3_BrandName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getDeviceFamilyName() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getPdc4_DeviceFamilyName() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getGenericName() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getPdc5_GenericName() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public ST[] getModelIdentifier() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getPdc6_ModelIdentifier() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getModelIdentifierReps() {
        return this.getReps(6);
    }

    public ST getModelIdentifier(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getPdc6_ModelIdentifier(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getPdc6_ModelIdentifierReps() {
        return this.getReps(6);
    }

    public ST insertModelIdentifier(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertPdc6_ModelIdentifier(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeModelIdentifier(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removePdc6_ModelIdentifier(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST getCatalogueIdentifier() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST getPdc7_CatalogueIdentifier() {
        ST retVal = (ST)this.getTypedField(7, 0);
        return retVal;
    }

    public ST[] getOtherIdentifier() {
        ST[] retVal = (ST[])this.getTypedField(8, new ST[0]);
        return retVal;
    }

    public ST[] getPdc8_OtherIdentifier() {
        ST[] retVal = (ST[])this.getTypedField(8, new ST[0]);
        return retVal;
    }

    public int getOtherIdentifierReps() {
        return this.getReps(8);
    }

    public ST getOtherIdentifier(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public ST getPdc8_OtherIdentifier(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public int getPdc8_OtherIdentifierReps() {
        return this.getReps(8);
    }

    public ST insertOtherIdentifier(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST insertPdc8_OtherIdentifier(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST removeOtherIdentifier(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public ST removePdc8_OtherIdentifier(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public CE getProductCode() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getPdc9_ProductCode() {
        CE retVal = (CE)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getMarketingBasis() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ID getPdc10_MarketingBasis() {
        ID retVal = (ID)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getMarketingApprovalID() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getPdc11_MarketingApprovalID() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ getLabeledShelfLife() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getPdc12_LabeledShelfLife() {
        CQ retVal = (CQ)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ getExpectedShelfLife() {
        CQ retVal = (CQ)this.getTypedField(13, 0);
        return retVal;
    }

    public CQ getPdc13_ExpectedShelfLife() {
        CQ retVal = (CQ)this.getTypedField(13, 0);
        return retVal;
    }

    public TS getDateFirstMarketed() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getPdc14_DateFirstMarketed() {
        TS retVal = (TS)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getDateLastMarketed() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public TS getPdc15_DateLastMarketed() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    @Override
    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new XON(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new CE(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(330));
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new CQ(this.getMessage());
            }
            case 12: {
                return new CQ(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new TS(this.getMessage());
            }
        }
        return null;
    }
}

