/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.OMP_O09_COMPONENT;
import ca.uhn.hl7v2.model.v24.group.OMP_O09_OBSERVATION;
import ca.uhn.hl7v2.model.v24.segment.BLG;
import ca.uhn.hl7v2.model.v24.segment.FT1;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.model.v24.segment.RXO;
import ca.uhn.hl7v2.model.v24.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OMP_O09_ORDER
extends AbstractGroup {
    public OMP_O09_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RXO.class, true, false, false);
            this.add(NTE.class, false, true, false);
            this.add(RXR.class, true, true, false);
            this.add(OMP_O09_COMPONENT.class, false, false, false);
            this.add(OMP_O09_OBSERVATION.class, false, true, false);
            this.add(FT1.class, false, true, false);
            this.add(BLG.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OMP_O09_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RXO getRXO() {
        RXO retVal = this.getTyped("RXO", RXO.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public RXR getRXR() {
        RXR retVal = this.getTyped("RXR", RXR.class);
        return retVal;
    }

    public RXR getRXR(int rep) {
        RXR retVal = this.getTyped("RXR", rep, RXR.class);
        return retVal;
    }

    public int getRXRReps() {
        return this.getReps("RXR");
    }

    public List<RXR> getRXRAll() throws HL7Exception {
        return this.getAllAsList("RXR", RXR.class);
    }

    public void insertRXR(RXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXR", structure, rep);
    }

    public RXR insertRXR(int rep) throws HL7Exception {
        return (RXR)super.insertRepetition("RXR", rep);
    }

    public RXR removeRXR(int rep) throws HL7Exception {
        return (RXR)super.removeRepetition("RXR", rep);
    }

    public OMP_O09_COMPONENT getCOMPONENT() {
        OMP_O09_COMPONENT retVal = this.getTyped("COMPONENT", OMP_O09_COMPONENT.class);
        return retVal;
    }

    public OMP_O09_OBSERVATION getOBSERVATION() {
        OMP_O09_OBSERVATION retVal = this.getTyped("OBSERVATION", OMP_O09_OBSERVATION.class);
        return retVal;
    }

    public OMP_O09_OBSERVATION getOBSERVATION(int rep) {
        OMP_O09_OBSERVATION retVal = this.getTyped("OBSERVATION", rep, OMP_O09_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<OMP_O09_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", OMP_O09_OBSERVATION.class);
    }

    public void insertOBSERVATION(OMP_O09_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public OMP_O09_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OMP_O09_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OMP_O09_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OMP_O09_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public FT1 getFT1() {
        FT1 retVal = this.getTyped("FT1", FT1.class);
        return retVal;
    }

    public FT1 getFT1(int rep) {
        FT1 retVal = this.getTyped("FT1", rep, FT1.class);
        return retVal;
    }

    public int getFT1Reps() {
        return this.getReps("FT1");
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }

    public BLG getBLG() {
        BLG retVal = this.getTyped("BLG", BLG.class);
        return retVal;
    }
}

