/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.views;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.core.ui.documents.Messages;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentsMetaDataDialog
extends TitleAreaDialog {
    private static Logger logger = LoggerFactory.getLogger(DocumentsMetaDataDialog.class);
    String file;
    IDocument document;
    Text tTitle;
    Text tKeywords;
    ComboViewer cbCategories;
    public String title;
    public String keywords;
    public String category;
    private final boolean categoryCrudAllowed;
    private final boolean keywordsCrudAllowed;

    public DocumentsMetaDataDialog(IDocument document, Shell parent) {
        super(parent);
        this.document = document;
        this.categoryCrudAllowed = DocumentStoreServiceHolder.getService().isAllowed(document, IDocumentStore.Capability.CATEGORY);
        this.keywordsCrudAllowed = DocumentStoreServiceHolder.getService().isAllowed(document, IDocumentStore.Capability.KEYWORDS);
    }

    protected Control createDialogArea(Composite parent) {
        Object cbSelection;
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        new Label(ret, 0).setText(Messages.DocumentView_categoryColumn);
        Composite cCats = new Composite(ret, 0);
        cCats.setFocus();
        cCats.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cCats.setLayout((Layout)new RowLayout(256));
        this.cbCategories = new ComboViewer(cCats, 12);
        this.cbCategories.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cbCategories.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICategory) {
                    ICategory iCategory = (ICategory)element;
                    return iCategory.getName();
                }
                return super.getText(element);
            }
        });
        List categories = DocumentStoreServiceHolder.getService().getCategories(this.document);
        this.cbCategories.setInput((Object)categories);
        Button bNewCat = new Button(cCats, 8);
        bNewCat.setVisible(this.categoryCrudAllowed);
        bNewCat.setImage(Images.IMG_NEW.getImage());
        bNewCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(DocumentsMetaDataDialog.this.getShell(), Messages.DocumentMetaDataDialog_newCategory, Messages.DocumentMetaDataDialog_newCategory, null, null);
                if (id.open() == 0) {
                    DocumentsMetaDataDialog.this.document.setCategory(DocumentStoreServiceHolder.getService().createCategory(DocumentsMetaDataDialog.this.document, id.getValue()));
                    if (!((List)DocumentsMetaDataDialog.this.cbCategories.getInput()).contains(DocumentsMetaDataDialog.this.document.getCategory())) {
                        DocumentsMetaDataDialog.this.cbCategories.add((Object)DocumentsMetaDataDialog.this.document.getCategory());
                    }
                    DocumentsMetaDataDialog.this.cbCategories.setSelection((ISelection)new StructuredSelection((Object)DocumentsMetaDataDialog.this.document.getCategory()), true);
                }
            }
        });
        Button bEditCat = new Button(cCats, 8);
        bEditCat.setImage(Images.IMG_EDIT.getImage());
        bEditCat.setVisible(this.categoryCrudAllowed);
        bEditCat.setToolTipText(Messages.DocumentMetaDataDialog_renameCategory);
        bEditCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id;
                ISelection old = DocumentsMetaDataDialog.this.cbCategories.getSelection();
                Object selection = ((StructuredSelection)old).getFirstElement();
                if (selection instanceof ICategory && (id = new InputDialog(DocumentsMetaDataDialog.this.getShell(), MessageFormat.format(Messages.DocumentMetaDataDialog_renameCategoryConfirm, ((ICategory)selection).getName()), Messages.DocumentMetaDataDialog_renameCategoryText, ((ICategory)selection).getName(), null)).open() == 0) {
                    DocumentStoreServiceHolder.getService().renameCategory(DocumentsMetaDataDialog.this.document, id.getValue());
                    ((ICategory)selection).setName(id.getValue());
                    DocumentsMetaDataDialog.this.cbCategories.refresh();
                }
            }
        });
        Button bDeleteCat = new Button(cCats, 8);
        bDeleteCat.setVisible(this.categoryCrudAllowed);
        bDeleteCat.setImage(Images.IMG_DELETE.getImage());
        bDeleteCat.setToolTipText(Messages.DocumentMetaDataDialog_deleteCategory);
        bDeleteCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ISelection old = DocumentsMetaDataDialog.this.cbCategories.getSelection();
                Object selection = ((StructuredSelection)old).getFirstElement();
                InputDialog id = new InputDialog(DocumentsMetaDataDialog.this.getShell(), MessageFormat.format(Messages.DocumentMetaDataDialog_deleteCategoryConfirm, ((ICategory)selection).getName()), Messages.DocumentMetaDataDialog_deleteCategoryText, "", null);
                if (id.open() == 0) {
                    try {
                        DocumentsMetaDataDialog.this.document.setCategory((ICategory)selection);
                        DocumentsMetaDataDialog.this.document.setCategory(DocumentStoreServiceHolder.getService().removeCategory(DocumentsMetaDataDialog.this.document, id.getValue()));
                        if (DocumentsMetaDataDialog.this.findComboElementByName(DocumentsMetaDataDialog.this.document.getCategory().getName()) == null) {
                            DocumentsMetaDataDialog.this.cbCategories.add((Object)DocumentsMetaDataDialog.this.document.getCategory());
                        }
                        DocumentsMetaDataDialog.this.cbCategories.remove(selection);
                        DocumentsMetaDataDialog.this.cbCategories.setSelection((ISelection)new StructuredSelection((Object)DocumentsMetaDataDialog.this.document.getCategory()), true);
                    }
                    catch (ElexisException e) {
                        logger.warn("existing document references", (Throwable)e);
                        SWTHelper.showError((String)Messages.DocumentMetaDataDialog_deleteCategoryError, (String)Messages.DocumentMetaDataDialog_deleteCategoryErrorText);
                    }
                }
            }
        });
        new Label(ret, 0).setText(Messages.DocumentsView_Title);
        this.tTitle = SWTHelper.createText((Composite)ret, (int)1, (int)0);
        new Label(ret, 0).setText(Messages.DocumentView_keywordsColumn);
        this.tKeywords = SWTHelper.createText((Composite)ret, (int)4, (int)0);
        this.tKeywords.setEnabled(this.keywordsCrudAllowed);
        this.tTitle.setText(this.document.getTitle());
        this.tKeywords.setText(this.document.getKeywords());
        Object object = cbSelection = this.document.getCategory() != null ? this.document.getCategory() : this.cbCategories.getElementAt(0);
        if (cbSelection != null) {
            if (!categories.contains(cbSelection)) {
                cbSelection = DocumentStoreServiceHolder.getService().getDefaultCategory(this.document);
            }
            this.cbCategories.setSelection((ISelection)new StructuredSelection(cbSelection), true);
        }
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(this.document.getTitle());
        this.getShell().setText(Messages.DocumentMetaDataDialog_title);
        this.setMessage(Messages.DocumentMetaDataDialog_titleMessage);
    }

    protected void okPressed() {
        if (this.keywordsCrudAllowed) {
            this.keywords = this.tKeywords.getText();
        }
        this.title = this.tTitle.getText();
        StructuredSelection comboSelection = (StructuredSelection)this.cbCategories.getSelection();
        if (this.document != null) {
            if (comboSelection != null) {
                this.document.setCategory((ICategory)comboSelection.getFirstElement());
            }
            this.document.setTitle(this.title);
            this.document.setKeywords(this.tKeywords.getText());
        }
        super.okPressed();
    }

    private ICategory findComboElementByName(String name) {
        List items = (List)this.cbCategories.getInput();
        if (items != null) {
            for (Object o : items) {
                if (!(o instanceof ICategory) || !((ICategory)o).getName().equals(name)) continue;
                return (ICategory)o;
            }
        }
        return null;
    }
}

