/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.utils;

import ch.rgw.tools.TimeTool;
import java.io.File;
import org.slf4j.LoggerFactory;

public class FileUtil {
    public static String removeInvalidChars(String filename) {
        if (filename != null) {
            return filename.replaceAll("[\\\\/:*?\"<>|]", "");
        }
        return filename;
    }

    public static void moveFileToParentDir(File file, String parentDirName) {
        File rootDir = file.getParentFile();
        File subDir = FileUtil.getOrCreateSubdir(rootDir, parentDirName);
        if (subDir != null) {
            FileUtil.moveToDir(file, subDir);
        }
    }

    private static void moveToDir(File file, File subDir) {
        File newFile = new File(subDir, file.getName());
        if (newFile.exists()) {
            String fnwts = String.valueOf(file.getName()) + "_" + new TimeTool().toString(13);
            newFile = new File(subDir, fnwts);
        }
        if (!file.renameTo(newFile)) {
            LoggerFactory.getLogger(FileUtil.class).error("Could not move file [" + file.getAbsolutePath() + "] to [" + newFile.getAbsolutePath() + "]");
        } else {
            LoggerFactory.getLogger(FileUtil.class).debug("The new file location is: " + newFile.getAbsolutePath());
        }
    }

    private static File getOrCreateSubdir(File dir, String string) {
        File subDir = new File(dir, string);
        if (!subDir.exists()) {
            subDir.mkdir();
        }
        return subDir;
    }
}

